#ifndef DLJOB_H_
#define DLJOB_H_

#include "meta.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class dlcon;

class tDlJob
{
public:
	
	bool bSuggestReconnect, bRequestEnqueued;
	
	inline bool HasBrokenStorage()
	{
		return (!m_pStorage || m_pStorage->GetStatus() >= FIST_ERROR);	
	}
	
    typedef enum {
    	R_DONE, // 0
    	R_MOREINPUT, //1
    	R_SKIPITEM, //2
        R_ERROR_REMOTE, //3
        R_ERROR_LOCAL, //4
        R_NOOP, // 5
        R_NEXTSTATE // 6
    } tDlResult;

    tDlResult ProcessIncomming(acbuf & inBuf, mstring & sErrorRet);

	tDlJob(dlcon *m, tFileItemPtr pFi, const mstring & sHost,
			const mstring & sPath);
	tDlJob(dlcon *m, tFileItemPtr pFi, acfg::tRepoData * pBackends,
			const mstring & sPath);
	virtual ~tDlJob();
	

	void UnregDownloader(const mstring &sError);
    void BlacklistBackend();
	
	bool FindConfig();
	
	// needs connectedHost, blacklist, output buffer from the parent, proxy mode?
	bool AppendRequest(mstring sForThisHostOnly, tSS &head, const tHttpUrl * pProxy);

	inline bool HasStarted() { return m_DlState>STATE_GETHEADER; }

	inline const mstring GetPeerName()
	{
		return m_pBackend ? m_pBackend->sHost : m_fileUri.sHost;
	}
    mstring RemoteUri();
    mstring RemotePath();
    
    acfg::tRepoData::IHookHandler * GetConnStateObserver();

protected:
	
	/**
	 * Called by the state machine when receiveing the data, allows the subclass to reimplement it.
	 * 
	 * @return: R_NEXTSTATE -> caller should switch state
	 * 			anything else: return that value
	 * */
	virtual tDlResult NewDataHandler(acbuf & inBuf, mstring &sErrorRet);
	
    typedef enum {
		STATE_GETHEADER
		,STATE_GETDATA
		,STATE_GETDATA_CHUNKED
		,STATE_GETCHUNKHEAD
		,STATE_FINISHJOB
	} tDlState;

	acfg::tRepoData * m_pHostiVec;
	tFileItemPtr m_pStorage;
	dlcon *m_parent;
	
	tHttpUrl m_fileUri, *m_pBackend;
	
	bool m_bReconnectASAP;
	
	off_t m_nRest;
	
	tDlState m_DlState;
	void _Init();
	
	// not to be copied
	tDlJob(const tDlJob&);
	tDlJob & operator=(const tDlJob&);
};

#endif /*DLJOB_H_*/
