
#ifndef _FILEITEM_H
#define _FILEITEM_H

#include <string>

#include "config.h"
#include "lockable.h"
#include <header.h>

// Life line (process states) of a file description item
#define FIST_FRESH 		0
#define FIST_INITED		1
#define FIST_DLPENDING		4
#define FIST_DLGOTHEAD		8
#define FIST_DLRECEIVING	16
#define FIST_COMPLETE		32
// usually unreachable states
#define FIST_ERROR 			999
#define FIST_ERRNOUSER		9999

// some fileitem members need to know them...
class fileitem;
typedef SHARED_PTR<fileitem> tFileItemPtr;

class fileitem : public condition
{

public:
	
	virtual ~fileitem();
	
	// initialize file item, return the status
	FiStatus Setup(bool bDynType, bool bIgnoreCached=false);
	
	virtual int GetFileFd();
	uint64_t GetTransferCount();
	// send helper like wrapper for sendfile. Just declare virtual here to make it better customizable later.
	virtual ssize_t SendData(int confd, int filefd, off_t &nSendPos, size_t nMax2SendNow);
	
	// downloader instruments
	
	bool DownloadStartedStoreHeader(const header & h);
	void AddDownloaderRef();
	void DelDownloaderRef(const MYSTD::string & sReasonStatusLine);
	//virtual void SetFailureMode(const MYSTD::string & message, FiStatus fist=FIST_ERROR,
	//	bool bOnlyIfNoDlRunnuning=false);
	
	/*!
	 * \return true IFF ok and caller might continue. False -> caller should abort.
	 */
	virtual bool StoreFileData(const char *data, unsigned int size);
	header const * GetHeaderUnlocked();
	
	FiStatus GetStatus() { setLockGuard; return status; }
	FiStatus GetStatusUnlocked(off_t &nGoodDataSize) { nGoodDataSize = m_nSizeChecked; return status; }
	
	bool m_bCheckFreshness;

	uint64_t m_nIncommingCount;
	off_t m_nSizeSeen;
	MYSTD::string m_sPath, m_sKey;
	
protected:
	fileitem(MYSTD::string);
	off_t m_nSizeChecked;
	header m_head;
	int m_filefd;
	int m_nDlRefsCount;
	FiStatus status;

	bool m_bAllowStoreData;


	////////////////////////////////
	// Item pool management methods
	////////////////////////////////
public:
	// public constructor wrapper, get a unique object from the map
	static tFileItemPtr GetFileItem(MYSTD::string sPath); // also opens the cached file and increases reference count
	virtual void Unreg(); // decrease dependent user count
};

extern lockable mapLck;

#endif


