<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>event - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Apache MPM event</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/event.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/event.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Une variante du MPM <code class="module"><a href="../mod/worker.html">worker</a></code> conue pour ne
mobiliser des threads que pour les connexions en cours de traitement</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>mpm_event_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>event.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Le module multi-processus (MPM) <code class="module"><a href="../mod/event.html">event</a></code> est conu
    pour permettre le traitement d'un nombre accru de requtes
    simultanes en dlguant certaines tches  des threads de support,
    librant par l-mme le thread principal et lui permettant de
    traiter les nouvelles requtes. Il s'inspire du MPM
    <code class="module"><a href="../mod/worker.html">worker</a></code> qui implmente un serveur hybride
    multi-processus/multi-threads. Les directives de configuration 
    l'excution sont identiques  celles du MPM
    <code class="module"><a href="../mod/worker.html">worker</a></code>.</p>

    <p>Pour utiliser le MPM <code class="module"><a href="../mod/event.html">event</a></code>, ajoutez
    <code>--with-mpm=event</code> aux arguments du script
    <code class="program"><a href="../programs/configure.html">configure</a></code> lorsque vous compilez le programme
    <code class="program"><a href="../programs/httpd.html">httpd</a></code>.</p>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#asyncrequestworkerfactor">AsyncRequestWorkerFactor</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#coredumpdirectory">CoreDumpDirectory</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#enableexceptionhook">EnableExceptionHook</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#group">Group</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listen">Listen</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listenbacklog">ListenBacklog</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxmemfree">MaxMemFree</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxsparethreads">MaxSpareThreads</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#minsparethreads">MinSpareThreads</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#pidfile">PidFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#scoreboardfile">ScoreBoardFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#sendbuffersize">SendBufferSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#serverlimit">ServerLimit</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#startservers">StartServers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadlimit">ThreadLimit</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadsperchild">ThreadsPerChild</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadstacksize">ThreadStackSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#user">User</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#how-it-works">Comment tout cela fonctionne</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requirements">Prrequis</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="worker.html">Le MPM worker</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="how-it-works" id="how-it-works">Comment tout cela fonctionne</a></h2>
    <p>Ce MPM essaie de rsoudre le 'problme keep alive' de HTTP.
    Lorsqu'un client a soumis une premire requte, il peut garder la
    connexion ouverte, et envoyer les requtes suivantes en utilisant le
    mme socket. Ceci permet de rduire de manire significative la
    surcharge due  la cration de connexions TCP.
    Cependant, le serveur HTTP Apache
    mobilise en principe  cet effet un processus/thread enfant en
    attente des donnes du client, ce qui amne son propre lot
    d'inconvnients. Pour rsoudre ce problme, <code class="module"><a href="../mod/event.html">event</a></code>
    utilise un thread ddi qui gre les sockets en
    coute, tous les sockets en tat Keep Alive, et les
    sockets o les filtres gestionnaires et de protocole ont
    fait leur travail et pour lesquels la seule chose restant  faire
    consiste  envoyer les donnes au client. La page d'tat de
    <code class="module"><a href="../mod/mod_status.html">mod_status</a></code> montre les connexions qui se trouvent
    dans les situations mentionnes.</p>

    <p>Le gestionnaire de connexion amlior ne fonctionne pas encore
    pour certains filtres de connexion, et en particulier SSL. Pour les
    connexions SSL, ce MPM radopte le comportement du MPM
    <code class="module"><a href="../mod/worker.html">worker</a></code> et rserve un thread par connexion.</p>

    <p>Le MPM prsuppose que l'implmentation <code>apr_pollset</code>
    sous-jacente est raisonnablement sre du point de vue des threads.
    Ceci permet au MPM d'viter un verrouillage de haut niveau excessif,
    ou de devoir activer le thread en coute afin de lui envoyer un
    socket keep alive. Tout ceci n'est actuellement compatible qu'avec
    KQueue et EPoll.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requirements" id="requirements">Prrequis</a></h2>
    <p>Ce MPM dpend des oprations atomiques compare-and-swap
    d'<a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a> pour la synchronisation des threads. Si
    vous compilez pour une plate-forme x86 et n'avez pas besoin du
    support 386, ou si vous compilez pour une plate-forme SPARC et
    n'avez pas besoin du support pre-UltraSPARC, ajoutez
    <code>--enable-nonportable-atomics=yes</code> aux arguments du
    script <code class="program"><a href="../programs/configure.html">configure</a></code>. Ceci permettra  APR
    d'implmenter les oprations atomiques en utilisant des instructions
    performantes indisponibles avec les processeurs plus
    anciens.</p>

    <p>Ce MPM ne fonctionne pas de manire optimale sur les
    plates-formes plus anciennes qui ne grent pas correctement les
    threads, mais ce problme est sans objet du fait du prrequis
    concernant EPoll ou KQueue.</p>

    <ul>

      <li>Pour utiliser ce MPM sous FreeBSD, la version 5.3 ou
      suprieure de ce systme est recommande. Il est cependant
      possible d'excuter ce MPM sous FreeBSD 5.2.1 si vous utilisez
      <code>libkse</code> (voir <code>man libmap.conf</code>).</li>

      <li>Pour NetBSD, il est recommander d'utiliser la version 2.0 ou
      suprieure.</li>

      <li>Pour Linux, un noyau 2.6 est recommand. Il faut aussi
      s'assurer que votre version de <code>glibc</code> a t compile
      avec le support pour EPoll.</li>

    </ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AsyncRequestWorkerFactor" id="AsyncRequestWorkerFactor">AsyncRequestWorkerFactor</a> <a name="asyncrequestworkerfactor" id="asyncrequestworkerfactor">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de connexions simultanes par thread</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AsyncRequestWorkerFactor <var>facteur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>event</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.13</td></tr>
</table>
    <p>Le MPM event gre certaines connexions de manire asynchrone ;
    dans ce cas, les threads traitant la requte sont allous selon les
    besoins et pour de courtes priodes. Dans les autres cas (la plupart
    du temps pour les connexions SSL), un thread est rserv par
    connexion. Ceci peut conduire  des situations o tous les threads
    sont saturs et o aucun thread n'est capable d'effectuer de
    nouvelles tches pour les connexions asynchrones tablies.</p>

    <p>Pour minimiser les effets de ce problme, le MPM event utilise
    deux mthodes : tout d'abord, il limite le nombre de connexions
    simultanes par thread en fonction du nombre de processus
    inactifs. Ensuite, si tous les processus sont occups, il ferme des
    connexions permanentes, mme si la limite de dure de la connexion
    n'a pas t atteinte. Ceci autorise les clients concerns  se
    reconnecter  un autre processus possdant encore des threads
    disponibles.</p>

    <p>Cette directive permet de personnaliser finement la limite du
    nombre de connexions par thread. Un processus n'acceptera de
    nouvelles connexions que si le nombre actuel de connexions est
    infrieur  :</p>

    <p class="indent"><strong>
        <code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> +
        (<code class="directive">AsyncRequestWorkerFactor</code> *
        <var>nombre de threads inactifs</var>)
    </strong></p>

    <p>En d'autres termes, le nombre maximum de connexions simultanes
    sera :</p>

    <p class="indent"><strong>
        (<code class="directive">AsyncRequestWorkerFactor</code> + 1) *
        <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code>
    </strong></p>

    <p>La directive <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code> se nommait
    <code class="directive">MaxClients</code> avant la version 2.3.13. La valeur
    ci-dessus montre que cet ancien nom ne correspondait pas  sa
    signification exacte pour le MPM event.</p>

    <p>La directive <code class="directive">AsyncRequestWorkerFactor</code>
    accepte des valeurs d'argument de type non entier, comme "1.5".</p>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/event.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/event.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>