// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef VIRTUSERADDRFILTER_H
#define VIRTUSERADDRFILTER_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif

#include "addrfilter.h"
#include <map>

/**Parse a virtusertable and translate all email addresses
  *@author Tobias Erbsland
  */

class virtuserAddrFilter : public AddrFilter
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	bool enabled; // true if this filter is enabled.

	std::map< std::string, std::string > mapVirtUser;

public:
	virtuserAddrFilter();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual bool init( void );
	virtual bool checkAddr( std::string &addr );

	~virtuserAddrFilter();
};

#endif
