// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "report.h"
#ifdef USE_SPRINTF
#include <cstdio>
#else
#include <sstream>
#endif

Report::Report() :
		dateformat( "" ),
		datesize( 0 ),
		os( 0 )
{
	addParam( "dateformat", "Change the default dateformat.", "3-5 letters from \"dmy-/.\".", Parameter::G_STRING, "" );
}

Report::~Report()
{
	// Never remove this. It's needet to create a .o file of this
	// abscrat class to avoid double definations.
}

void Report::checkDateformat( void )
{
	// check if dateformat already set.
	if ( dateformat == "" )
	{
		dateformat = getStringParam( "dateformat" );
		// check valid format first...
		if ( ( dateformat.size() > 5 ) || ( dateformat.size() < 1 ) ||
		        ( dateformat.find_first_not_of( "dmy.-/" ) != std::string::npos ) )
			dateformat = "d.m.y"; //default
		// calculate the datesize.
		std::string::size_type i;
		datesize = 0; // hm.. remove this?
		for ( i = 0; i < dateformat.size(); i++ )
		{
			char c = dateformat[ i ];
			if ( c == 'd' || c == 'm' )
				datesize += 2;
			else if ( c == 'y' )
				datesize += 4;
			else
				datesize++;
		}
	}
}

/** Convert a unix timestamp to a string.
  */
std::string Report::getDateStr( time_t t )
{
	checkDateformat();
	tm tmdate = *( localtime( &t ) );
#ifndef USE_SPRINTF
	std::ostringstream ostr;
	std::string::size_type i;
	for ( i = 0; i < dateformat.size(); i++ )
	{
		switch ( dateformat[ i ] )
		{
			case 'd':
				ostr.width( 2 );
				ostr.fill( '0' );
				ostr << tmdate.tm_mday;
				break;
			case 'm':
				ostr.width( 2 );
				ostr.fill( '0' );
				ostr << tmdate.tm_mon + 1;
				break;
			case 'y':
				ostr.width( 4 );
				ostr.fill( '0' );
				ostr << tmdate.tm_year + 1900;
				break;
			default:
				ostr << dateformat[ i ];
				break;
		}
	}
	return ostr.str();
#else
	char c_datestring[ datesize + 1 ];
	std::string format;
	std::string::size_type i;
	for ( i = 0; i < dateformat.size(); i++ )
	{
		switch ( dateformat[ i ] )
		{
			case 'd':
				format += "%1$02d";
				break;
			case 'm':
				format += "%2$02d";
				break;
			case 'y':
				format += "%3$04d";
				break;
			default:
				format += dateformat[ i ];
				break;
		}
	}
	sprintf( c_datestring, format.c_str(), ( int ) tmdate.tm_mday, ( int ) tmdate.tm_mon + 1, ( int ) tmdate.tm_year + 1900 );
	std::string newdate = c_datestring;
	return newdate;
#endif

}

int Report::getDateLenght( void )
{
	checkDateformat();
	return datesize;
}

void Report::addCol( const int colSize, const colTyp_e colTyp, const colAlign_e colAlign,
                     const std::string &colTitle, const colStyle_e colStyle, const unsigned long colFlags )
{
	if ( Type == TABLE )
	{
		col_t newCol;
		if ( colTyp == DATE )
			newCol.Size = getDateLenght();
		else
			newCol.Size = colSize;
		newCol.Typ = colTyp;
		newCol.Align = colAlign;
		newCol.Style = colStyle;
		newCol.Title = colTitle;
		newCol.floatSum = 0.0;
		newCol.longSum = 0;
		if ( colTyp == INTEGER || colTyp == FLOAT )
			newCol.Sum = ( ( colFlags & SUM ) == SUM );
		else
			newCol.Sum = false;
		col_list.push_back( newCol );
	}
}

void Report::startNewReport( const std::string &title, const reportType_e reportType )
{
	// clear column list.
	col_list.clear();
	// Set the Report title.
	Title = title;
	// Set the report type.
	Type = reportType;
}
