// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdlib>

#include "clp.h"
#include "poa.h"

#include "syslogfilter.h"
#include "postfixfilter.h"
// add your new filter here...
#include "aliasesaddrfilter.h"
#include "lowercaseaddrfilter.h"
#include "virtuseraddrfilter.h"
// add your new addressfilter here...
#include "ltanalyse.h"
#include "ltdanalyse.h"
#include "xtanalyse.h"
#include "mtanalyse.h"
#include "mfanalyse.h"
#include "mfipanalyse.h"
#include "bmanalyse.h"
#include "mranalyse.h"
// add your new analyse type here...
#include "asciireport.h"
#include "htmlreport.h"
// add your new report here...
#include "filterplugin.h"
#include "analyseplugin.h"
#include "reportplugin.h"
// add your new plugin here...


int main( int argc, char *argv[] )
{

	// Register all Objects
	poa::addObject( new syslogFilter() );
	poa::addObject( new postfixFilter() );
	// add your new Filter here.
	poa::addObject( new lowercaseAddrFilter() );
	poa::addObject( new virtuserAddrFilter() );
	poa::addObject( new aliasesAddrFilter() );
	// add your new Addressfilter here.
	poa::addObject( new ltAnalyse() );
	poa::addObject( new ltdAnalyse() );
	poa::addObject( new xtAnalyse() );
	poa::addObject( new mtAnalyse() );
	poa::addObject( new mfAnalyse() );
	poa::addObject( new mfipAnalyse() );
	poa::addObject( new bmAnalyse() );
	poa::addObject( new mrAnalyse() );
	// add your new Analyse here.
	poa::addObject( new asciiReport() );
	poa::addObject( new htmlReport() );
	// add your new Report here.
	poa::addObject( new filterPlugin() );
	poa::addObject( new analysePlugin() );
	poa::addObject( new reportPlugin() );
	// add your new Plugin here.

	// Parse the Commandline.
	//
	// Builtin Parameters are:
	//  -v = Print only Version and exit.
	//  -m = Print informations about all Modules and exit.
	if ( !clp::parse( argc, argv ) ) return EXIT_FAILURE;

	// call init() in every Plugin, and disable unused plugins.
	if ( !poa::initPlugins() ) return EXIT_FAILURE;

	// call filter() in every Plugin.
	if ( !poa::filterPlugins() ) return EXIT_FAILURE;

	// call analyse() in every Plugin.
	if ( !poa::analysePlugins() ) return EXIT_FAILURE;

	// call free() in every Plugin.
	if ( !poa::freePlugins() ) return EXIT_FAILURE;

	// exit.
	return EXIT_SUCCESS;
}
