// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "filterplugin.h"
#include "poa.h"
#include <fstream>

filterPlugin::filterPlugin() :
		strPrefix( "filter" ),
		strName( "Filter Plugin" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "For all filter parameters." )
{
	addParam( "file", "Read this file, instead from stdin.", "Path of the file.", STRING, "" );
	addParam( "disable", "Disable all addressfilters.", "This is a flag.", FLAG, "0" );
}

filterPlugin::~filterPlugin()
{
}

filterPlugin::ps_e filterPlugin::init( void )
{
	// Setup all Filters with the functioncall to *this* object.
	//  Shit! "not implemented" in the compiler!? hae...
	//  Change it to a pointer to the plugin.
	std::list< Filter * >::iterator i;
	for ( i = maps.f->begin(); i != maps.f->end(); i++ )
	{
		( *i ) ->setCheckAddr( this );
	}
	// Init all for all adressfilters.
	disable_addrfilter = getFlagParam( "disable" );
	if ( !disable_addrfilter )
	{
		std::list< AddrFilter * >::iterator i;
		for ( i = maps.d->begin(); i != maps.d->end(); i++ )
		{
			if ( !( ( *i ) ->init() ) )  // Error?
				return PS_STOP;
		}
	}

	return PS_ENABLE;
}

bool filterPlugin::addrFilter( std::string &addr )
{
	if ( !disable_addrfilter )
	{
		std::list< AddrFilter * >::iterator i;
		bool changes = false;
		for ( i = maps.d->begin(); i != maps.d->end(); i++ )
		{
			if ( ( *i ) ->checkAddr( addr ) )  // Error?
				changes = true;
		}
		return changes;
	}
	else
	{
		return false;
	}
}

void filterPlugin::beforeParam( void )
{
	std::list< Filter * >::iterator i;
	for ( i = maps.f->begin(); i != maps.f->end(); i++ )
	{
		addParam( (*i)->Prefix(), "Switch to this filter.", "This is a flag.", FLAG, "0" );
	}
}

filterPlugin::ps_e filterPlugin::filter( void )
{
	// Read from a file
	std::fstream inputFile; // without parameters, open file later.

	std::list<Filter *>::iterator useFilter = poa::filter_list.end();

	// Set the filter
	std::list<Filter *>::iterator fi;
	for( fi = poa::filter_list.begin(); fi != poa::filter_list.end(); fi++ )
	{
		// Enable this filter?
		if( getFlagParam( (*fi)->Prefix() ) )
		{
			// ok, then copy the iterator
			if( useFilter != poa::filter_list.end() )
			{
				std::cerr << "You selected two input filter." << std::endl;
				return PS_STOP; // abort.
			}
			else
			{
				useFilter = fi;
			}
		}
	}

	if( useFilter == poa::filter_list.end() )
	{
		std::cerr << "You must select at least one input filter." << std::endl;
		return PS_STOP; // abort.
	}

	if ( getStringParam( "file" ) != "" )  // input from a file?
	{
		// Try to open this file.
		inputFile.open( getStringParam( "file" ).c_str(), std::ios::in );
		if( inputFile.good() )  // ok?
		{
			(*useFilter)->setIstream( &inputFile );
		}
		else
		{ // some errors...
			std::cerr << "Can't open File \"" << getStringParam( "file" ) << "\"." << std::endl;
			return PS_STOP; // abort.
		}
	}
	else
	{ // no, use stdin.
		(*useFilter)->setIstream( &std::cin );
	}

	if( (*useFilter)->run() )  // running, filter - ok?
	{
		return PS_CONTINUE; // yes..
	}
	else
	{
		return PS_STOP; // no something went wrong
	}
}
