// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef CLP_H
#define CLP_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <string>
#include "parameter.h"

namespace clp
{

enum global_flags_t
{
    GF_VERSION = 1,
    GF_VERBOSE = 2,
    GF_QUIET = 4,
    GF_MODULEINFO = 8,
};

// Create a map with all global Parameters
extern std::map< std::string, Parameter::param_user_t > global_param_map;
// Create a map with all local Parameters
extern std::map< std::string, Parameter * > local_param_map;
// Store global single builtin Parameterflags
extern int global_flags;

// scan for local and global Parameters and add these to the maps.
void scanAllParameter( Parameter &po );

// parse the commandline for valid parameters
bool parse( int argc, char **argv );

// Error output
bool parseError( const std::string &wrong, const long line = 0 );

}

#endif

