/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NDMP2_H_RPCGEN
#define _NDMP2_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#ifndef NDMOS_OPTION_NO_NDMP2
#define NDMP2VER 2
#define NDMP2PORT 10000
#define ndmp2_u_quad unsigned long long
extern bool_t xdr_ndmp2_u_quad();

struct _ndmp2_u_quad {
	u_long high;
	u_long low;
};
typedef struct _ndmp2_u_quad _ndmp2_u_quad;

struct ndmp2_pval {
	char *name;
	char *value;
};
typedef struct ndmp2_pval ndmp2_pval;

struct ndmp2_scsi_device {
	char *name;
};
typedef struct ndmp2_scsi_device ndmp2_scsi_device;

struct ndmp2_tape_device {
	char *name;
};
typedef struct ndmp2_tape_device ndmp2_tape_device;

enum ndmp2_error {
	NDMP2_NO_ERR = 0,
	NDMP2_NOT_SUPPORTED_ERR = 1,
	NDMP2_DEVICE_BUSY_ERR = 2,
	NDMP2_DEVICE_OPENED_ERR = 3,
	NDMP2_NOT_AUTHORIZED_ERR = 4,
	NDMP2_PERMISSION_ERR = 5,
	NDMP2_DEV_NOT_OPEN_ERR = 6,
	NDMP2_IO_ERR = 7,
	NDMP2_TIMEOUT_ERR = 8,
	NDMP2_ILLEGAL_ARGS_ERR = 9,
	NDMP2_NO_TAPE_LOADED_ERR = 10,
	NDMP2_WRITE_PROTECT_ERR = 11,
	NDMP2_EOF_ERR = 12,
	NDMP2_EOM_ERR = 13,
	NDMP2_FILE_NOT_FOUND_ERR = 14,
	NDMP2_BAD_FILE_ERR = 15,
	NDMP2_NO_DEVICE_ERR = 16,
	NDMP2_NO_BUS_ERR = 17,
	NDMP2_XDR_DECODE_ERR = 18,
	NDMP2_ILLEGAL_STATE_ERR = 19,
	NDMP2_UNDEFINED_ERR = 20,
	NDMP2_XDR_ENCODE_ERR = 21,
	NDMP2_NO_MEM_ERR = 22,
};
typedef enum ndmp2_error ndmp2_error;

enum ndmp2_header_message_type {
	NDMP2_MESSAGE_REQUEST = 0,
	NDMP2_MESSAGE_REPLY = 1,
};
typedef enum ndmp2_header_message_type ndmp2_header_message_type;

enum ndmp2_message {
	NDMP2_CONNECT_OPEN = 0x900,
	NDMP2_CONNECT_CLIENT_AUTH = 0x900 + 1,
	NDMP2_CONNECT_CLOSE = 0x900 + 2,
	NDMP2_CONNECT_SERVER_AUTH = 0x900 + 3,
	NDMP2_CONFIG_GET_HOST_INFO = 0x100,
	NDMP2_CONFIG_GET_BUTYPE_ATTR = 0x100 + 1,
	NDMP2_CONFIG_GET_MOVER_TYPE = 0x100 + 2,
	NDMP2_CONFIG_GET_AUTH_ATTR = 0x100 + 3,
	NDMP2_SCSI_OPEN = 0x200,
	NDMP2_SCSI_CLOSE = 0x200 + 1,
	NDMP2_SCSI_GET_STATE = 0x200 + 2,
	NDMP2_SCSI_SET_TARGET = 0x200 + 3,
	NDMP2_SCSI_RESET_DEVICE = 0x200 + 4,
	NDMP2_SCSI_RESET_BUS = 0x200 + 5,
	NDMP2_SCSI_EXECUTE_CDB = 0x200 + 6,
	NDMP2_TAPE_OPEN = 0x300,
	NDMP2_TAPE_CLOSE = 0x300 + 1,
	NDMP2_TAPE_GET_STATE = 0x300 + 2,
	NDMP2_TAPE_MTIO = 0x300 + 3,
	NDMP2_TAPE_WRITE = 0x300 + 4,
	NDMP2_TAPE_READ = 0x300 + 5,
	NDMP2_TAPE_RESVD1 = 0x300 + 6,
	NDMP2_TAPE_EXECUTE_CDB = 0x300 + 7,
	NDMP2_DATA_GET_STATE = 0x400,
	NDMP2_DATA_START_BACKUP = 0x400 + 1,
	NDMP2_DATA_START_RECOVER = 0x400 + 2,
	NDMP2_DATA_ABORT = 0x400 + 3,
	NDMP2_DATA_GET_ENV = 0x400 + 4,
	NDMP2_DATA_RESVD1 = 0x400 + 5,
	NDMP2_DATA_RESVD2 = 0x400 + 6,
	NDMP2_DATA_STOP = 0x400 + 7,
	NDMP2_DATA_START_RECOVER_FILEHIST = 0x40b,
	NDMP2_NOTIFY_RESVD1 = 0x500,
	NDMP2_NOTIFY_DATA_HALTED = 0x500 + 1,
	NDMP2_NOTIFY_CONNECTED = 0x500 + 2,
	NDMP2_NOTIFY_MOVER_HALTED = 0x500 + 3,
	NDMP2_NOTIFY_MOVER_PAUSED = 0x500 + 4,
	NDMP2_NOTIFY_DATA_READ = 0x500 + 5,
	NDMP2_LOG_LOG = 0x600,
	NDMP2_LOG_DEBUG = 0x600 + 1,
	NDMP2_LOG_FILE = 0x600 + 2,
	NDMP2_FH_ADD_UNIX_PATH = 0x700,
	NDMP2_FH_ADD_UNIX_DIR = 0x700 + 1,
	NDMP2_FH_ADD_UNIX_NODE = 0x700 + 2,
	NDMP2_MOVER_GET_STATE = 0xa00,
	NDMP2_MOVER_LISTEN = 0xa00 + 1,
	NDMP2_MOVER_CONTINUE = 0xa00 + 2,
	NDMP2_MOVER_ABORT = 0xa00 + 3,
	NDMP2_MOVER_STOP = 0xa00 + 4,
	NDMP2_MOVER_SET_WINDOW = 0xa00 + 5,
	NDMP2_MOVER_READ = 0xa00 + 6,
	NDMP2_MOVER_CLOSE = 0xa00 + 7,
	NDMP2_MOVER_SET_RECORD_SIZE = 0xa00 + 8,
	NDMP2_RESERVED = 0xff00,
};
typedef enum ndmp2_message ndmp2_message;

struct ndmp2_header {
	u_long sequence;
	u_long time_stamp;
	ndmp2_header_message_type message_type;
	ndmp2_message message;
	u_long reply_sequence;
	ndmp2_error error;
};
typedef struct ndmp2_header ndmp2_header;

struct ndmp2_connect_open_request {
	u_short protocol_version;
};
typedef struct ndmp2_connect_open_request ndmp2_connect_open_request;

struct ndmp2_connect_open_reply {
	ndmp2_error error;
};
typedef struct ndmp2_connect_open_reply ndmp2_connect_open_reply;

enum ndmp2_auth_type {
	NDMP2_AUTH_NONE = 0,
	NDMP2_AUTH_TEXT = 1,
	NDMP2_AUTH_MD5 = 2,
};
typedef enum ndmp2_auth_type ndmp2_auth_type;

struct ndmp2_auth_text {
	char *auth_id;
	char *auth_password;
};
typedef struct ndmp2_auth_text ndmp2_auth_text;

struct ndmp2_auth_md5 {
	char *auth_id;
	char auth_digest[16];
};
typedef struct ndmp2_auth_md5 ndmp2_auth_md5;

struct ndmp2_auth_data {
	ndmp2_auth_type auth_type;
	union {
		ndmp2_auth_text auth_text;
		ndmp2_auth_md5 auth_md5;
	} ndmp2_auth_data_u;
};
typedef struct ndmp2_auth_data ndmp2_auth_data;

struct ndmp2_connect_client_auth_request {
	ndmp2_auth_data auth_data;
};
typedef struct ndmp2_connect_client_auth_request ndmp2_connect_client_auth_request;

struct ndmp2_connect_client_auth_reply {
	ndmp2_error error;
};
typedef struct ndmp2_connect_client_auth_reply ndmp2_connect_client_auth_reply;

struct ndmp2_auth_attr {
	ndmp2_auth_type auth_type;
	union {
		char challenge[64];
	} ndmp2_auth_attr_u;
};
typedef struct ndmp2_auth_attr ndmp2_auth_attr;

struct ndmp2_connect_server_auth_request {
	ndmp2_auth_attr client_attr;
};
typedef struct ndmp2_connect_server_auth_request ndmp2_connect_server_auth_request;

struct ndmp2_connect_server_auth_reply {
	ndmp2_error error;
	ndmp2_auth_data auth_result;
};
typedef struct ndmp2_connect_server_auth_reply ndmp2_connect_server_auth_reply;

struct ndmp2_config_get_host_info_reply {
	ndmp2_error error;
	char *hostname;
	char *os_type;
	char *os_vers;
	char *hostid;
	struct {
		u_int auth_type_len;
		ndmp2_auth_type *auth_type_val;
	} auth_type;
};
typedef struct ndmp2_config_get_host_info_reply ndmp2_config_get_host_info_reply;
#define NDMP2_NO_BACKUP_FILELIST 0x0001
#define NDMP2_NO_BACKUP_FHINFO 0x0002
#define NDMP2_NO_RECOVER_FILELIST 0x0004
#define NDMP2_NO_RECOVER_FHINFO 0x0008
#define NDMP2_NO_RECOVER_RESVD 0x0010
#define NDMP2_NO_RECOVER_INC_ONLY 0x0020

struct ndmp2_config_get_butype_attr_request {
	char *name;
};
typedef struct ndmp2_config_get_butype_attr_request ndmp2_config_get_butype_attr_request;

struct ndmp2_config_get_butype_attr_reply {
	ndmp2_error error;
	u_long attrs;
};
typedef struct ndmp2_config_get_butype_attr_reply ndmp2_config_get_butype_attr_reply;

enum ndmp2_mover_addr_type {
	NDMP2_ADDR_LOCAL = 0,
	NDMP2_ADDR_TCP = 1,
};
typedef enum ndmp2_mover_addr_type ndmp2_mover_addr_type;

struct ndmp2_config_get_mover_type_reply {
	ndmp2_error error;
	struct {
		u_int methods_len;
		ndmp2_mover_addr_type *methods_val;
	} methods;
};
typedef struct ndmp2_config_get_mover_type_reply ndmp2_config_get_mover_type_reply;

struct ndmp2_config_get_auth_attr_request {
	ndmp2_auth_type auth_type;
};
typedef struct ndmp2_config_get_auth_attr_request ndmp2_config_get_auth_attr_request;

struct ndmp2_config_get_auth_attr_reply {
	ndmp2_error error;
	ndmp2_auth_attr server_attr;
};
typedef struct ndmp2_config_get_auth_attr_reply ndmp2_config_get_auth_attr_reply;

struct ndmp2_scsi_open_request {
	ndmp2_scsi_device device;
};
typedef struct ndmp2_scsi_open_request ndmp2_scsi_open_request;

struct ndmp2_scsi_open_reply {
	ndmp2_error error;
};
typedef struct ndmp2_scsi_open_reply ndmp2_scsi_open_reply;

struct ndmp2_scsi_close_reply {
	ndmp2_error error;
};
typedef struct ndmp2_scsi_close_reply ndmp2_scsi_close_reply;

struct ndmp2_scsi_get_state_reply {
	ndmp2_error error;
	short target_controller;
	short target_id;
	short target_lun;
};
typedef struct ndmp2_scsi_get_state_reply ndmp2_scsi_get_state_reply;

struct ndmp2_scsi_set_target_request {
	ndmp2_scsi_device device;
	u_short target_controller;
	u_short target_id;
	u_short target_lun;
};
typedef struct ndmp2_scsi_set_target_request ndmp2_scsi_set_target_request;

struct ndmp2_scsi_set_target_reply {
	ndmp2_error error;
};
typedef struct ndmp2_scsi_set_target_reply ndmp2_scsi_set_target_reply;

struct ndmp2_scsi_reset_device_reply {
	ndmp2_error error;
};
typedef struct ndmp2_scsi_reset_device_reply ndmp2_scsi_reset_device_reply;

struct ndmp2_scsi_reset_bus_reply {
	ndmp2_error error;
};
typedef struct ndmp2_scsi_reset_bus_reply ndmp2_scsi_reset_bus_reply;
#define NDMP2_SCSI_DATA_IN 0x00000001
#define NDMP2_SCSI_DATA_OUT 0x00000002

struct ndmp2_execute_cdb_request {
	u_long flags;
	u_long timeout;
	u_long datain_len;
	struct {
		u_int cdb_len;
		char *cdb_val;
	} cdb;
	struct {
		u_int dataout_len;
		char *dataout_val;
	} dataout;
};
typedef struct ndmp2_execute_cdb_request ndmp2_execute_cdb_request;

struct ndmp2_execute_cdb_reply {
	ndmp2_error error;
	u_char status;
	u_long dataout_len;
	struct {
		u_int datain_len;
		char *datain_val;
	} datain;
	struct {
		u_int ext_sense_len;
		char *ext_sense_val;
	} ext_sense;
};
typedef struct ndmp2_execute_cdb_reply ndmp2_execute_cdb_reply;

typedef ndmp2_execute_cdb_request ndmp2_scsi_execute_cdb_request;

typedef ndmp2_execute_cdb_reply ndmp2_scsi_execute_cdb_reply;

enum ndmp2_tape_open_mode {
	NDMP2_TAPE_READ_MODE = 0,
	NDMP2_TAPE_WRITE_MODE = 1,
};
typedef enum ndmp2_tape_open_mode ndmp2_tape_open_mode;

struct ndmp2_tape_open_request {
	ndmp2_tape_device device;
	ndmp2_tape_open_mode mode;
};
typedef struct ndmp2_tape_open_request ndmp2_tape_open_request;

struct ndmp2_tape_open_reply {
	ndmp2_error error;
};
typedef struct ndmp2_tape_open_reply ndmp2_tape_open_reply;

struct ndmp2_tape_close_reply {
	ndmp2_error error;
};
typedef struct ndmp2_tape_close_reply ndmp2_tape_close_reply;
#define NDMP2_TAPE_NOREWIND 0x0008
#define NDMP2_TAPE_WR_PROT 0x0010
#define NDMP2_TAPE_ERROR 0x0020
#define NDMP2_TAPE_UNLOAD 0x0040

struct ndmp2_tape_get_state_reply {
	ndmp2_error error;
	u_long flags;
	u_long file_num;
	u_long soft_errors;
	u_long block_size;
	u_long blockno;
	ndmp2_u_quad total_space;
	ndmp2_u_quad space_remain;
};
typedef struct ndmp2_tape_get_state_reply ndmp2_tape_get_state_reply;

enum ndmp2_tape_mtio_op {
	NDMP2_MTIO_FSF = 0,
	NDMP2_MTIO_BSF = 1,
	NDMP2_MTIO_FSR = 2,
	NDMP2_MTIO_BSR = 3,
	NDMP2_MTIO_REW = 4,
	NDMP2_MTIO_EOF = 5,
	NDMP2_MTIO_OFF = 6,
};
typedef enum ndmp2_tape_mtio_op ndmp2_tape_mtio_op;

struct ndmp2_tape_mtio_request {
	ndmp2_tape_mtio_op tape_op;
	u_long count;
};
typedef struct ndmp2_tape_mtio_request ndmp2_tape_mtio_request;

struct ndmp2_tape_mtio_reply {
	ndmp2_error error;
	u_long resid_count;
};
typedef struct ndmp2_tape_mtio_reply ndmp2_tape_mtio_reply;

struct ndmp2_tape_write_request {
	struct {
		u_int data_out_len;
		char *data_out_val;
	} data_out;
};
typedef struct ndmp2_tape_write_request ndmp2_tape_write_request;

struct ndmp2_tape_write_reply {
	ndmp2_error error;
	u_long count;
};
typedef struct ndmp2_tape_write_reply ndmp2_tape_write_reply;

struct ndmp2_tape_read_request {
	u_long count;
};
typedef struct ndmp2_tape_read_request ndmp2_tape_read_request;

struct ndmp2_tape_read_reply {
	ndmp2_error error;
	struct {
		u_int data_in_len;
		char *data_in_val;
	} data_in;
};
typedef struct ndmp2_tape_read_reply ndmp2_tape_read_reply;

typedef ndmp2_execute_cdb_request ndmp2_tape_execute_cdb_request;

typedef ndmp2_execute_cdb_reply ndmp2_tape_execute_cdb_reply;

enum ndmp2_mover_state {
	NDMP2_MOVER_STATE_IDLE = 0,
	NDMP2_MOVER_STATE_LISTEN = 1,
	NDMP2_MOVER_STATE_ACTIVE = 2,
	NDMP2_MOVER_STATE_PAUSED = 3,
	NDMP2_MOVER_STATE_HALTED = 4,
};
typedef enum ndmp2_mover_state ndmp2_mover_state;

enum ndmp2_mover_pause_reason {
	NDMP2_MOVER_PAUSE_NA = 0,
	NDMP2_MOVER_PAUSE_EOM = 1,
	NDMP2_MOVER_PAUSE_EOF = 2,
	NDMP2_MOVER_PAUSE_SEEK = 3,
	NDMP2_MOVER_PAUSE_MEDIA_ERROR = 4,
};
typedef enum ndmp2_mover_pause_reason ndmp2_mover_pause_reason;

enum ndmp2_mover_halt_reason {
	NDMP2_MOVER_HALT_NA = 0,
	NDMP2_MOVER_HALT_CONNECT_CLOSED = 1,
	NDMP2_MOVER_HALT_ABORTED = 2,
	NDMP2_MOVER_HALT_INTERNAL_ERROR = 3,
	NDMP2_MOVER_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp2_mover_halt_reason ndmp2_mover_halt_reason;

struct ndmp2_mover_get_state_reply {
	ndmp2_error error;
	ndmp2_mover_state state;
	ndmp2_mover_pause_reason pause_reason;
	ndmp2_mover_halt_reason halt_reason;
	u_long record_size;
	u_long record_num;
	ndmp2_u_quad data_written;
	ndmp2_u_quad seek_position;
	ndmp2_u_quad bytes_left_to_read;
	ndmp2_u_quad window_offset;
	ndmp2_u_quad window_length;
};
typedef struct ndmp2_mover_get_state_reply ndmp2_mover_get_state_reply;

enum ndmp2_mover_mode {
	NDMP2_MOVER_MODE_READ = 0,
	NDMP2_MOVER_MODE_WRITE = 1,
	NDMP2_MOVER_MODE_DATA = 2,
};
typedef enum ndmp2_mover_mode ndmp2_mover_mode;

struct ndmp2_mover_tcp_addr {
	u_long ip_addr;
	u_short port;
};
typedef struct ndmp2_mover_tcp_addr ndmp2_mover_tcp_addr;

struct ndmp2_mover_addr {
	ndmp2_mover_addr_type addr_type;
	union {
		ndmp2_mover_tcp_addr addr;
	} ndmp2_mover_addr_u;
};
typedef struct ndmp2_mover_addr ndmp2_mover_addr;

struct ndmp2_mover_listen_request {
	ndmp2_mover_mode mode;
	ndmp2_mover_addr_type addr_type;
};
typedef struct ndmp2_mover_listen_request ndmp2_mover_listen_request;

struct ndmp2_mover_listen_reply {
	ndmp2_error error;
	ndmp2_mover_addr mover;
};
typedef struct ndmp2_mover_listen_reply ndmp2_mover_listen_reply;

struct ndmp2_mover_set_record_size_request {
	u_long len;
};
typedef struct ndmp2_mover_set_record_size_request ndmp2_mover_set_record_size_request;

struct ndmp2_mover_set_record_size_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_set_record_size_reply ndmp2_mover_set_record_size_reply;

struct ndmp2_mover_set_window_request {
	ndmp2_u_quad offset;
	ndmp2_u_quad length;
};
typedef struct ndmp2_mover_set_window_request ndmp2_mover_set_window_request;

struct ndmp2_mover_set_window_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_set_window_reply ndmp2_mover_set_window_reply;

struct ndmp2_mover_continue_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_continue_reply ndmp2_mover_continue_reply;

struct ndmp2_mover_abort_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_abort_reply ndmp2_mover_abort_reply;

struct ndmp2_mover_stop_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_stop_reply ndmp2_mover_stop_reply;

struct ndmp2_mover_read_request {
	ndmp2_u_quad offset;
	ndmp2_u_quad length;
};
typedef struct ndmp2_mover_read_request ndmp2_mover_read_request;

struct ndmp2_mover_read_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_read_reply ndmp2_mover_read_reply;

struct ndmp2_mover_close_reply {
	ndmp2_error error;
};
typedef struct ndmp2_mover_close_reply ndmp2_mover_close_reply;

enum ndmp2_data_operation {
	NDMP2_DATA_OP_NOACTION = 0,
	NDMP2_DATA_OP_BACKUP = 1,
	NDMP2_DATA_OP_RESTORE = 2,
	NDMP2_DATA_OP_RESTORE_FILEHIST = 3,
};
typedef enum ndmp2_data_operation ndmp2_data_operation;

enum ndmp2_data_state {
	NDMP2_DATA_STATE_IDLE = 0,
	NDMP2_DATA_STATE_ACTIVE = 1,
	NDMP2_DATA_STATE_HALTED = 2,
};
typedef enum ndmp2_data_state ndmp2_data_state;

enum ndmp2_data_halt_reason {
	NDMP2_DATA_HALT_NA = 0,
	NDMP2_DATA_HALT_SUCCESSFUL = 1,
	NDMP2_DATA_HALT_ABORTED = 2,
	NDMP2_DATA_HALT_INTERNAL_ERROR = 3,
	NDMP2_DATA_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp2_data_halt_reason ndmp2_data_halt_reason;

struct ndmp2_data_get_state_reply {
	ndmp2_error error;
	ndmp2_data_operation operation;
	ndmp2_data_state state;
	ndmp2_data_halt_reason halt_reason;
	ndmp2_u_quad bytes_processed;
	ndmp2_u_quad est_bytes_remain;
	u_long est_time_remain;
	ndmp2_mover_addr mover;
	ndmp2_u_quad read_offset;
	ndmp2_u_quad read_length;
};
typedef struct ndmp2_data_get_state_reply ndmp2_data_get_state_reply;

struct ndmp2_data_start_backup_request {
	ndmp2_mover_addr mover;
	char *bu_type;
	struct {
		u_int env_len;
		ndmp2_pval *env_val;
	} env;
};
typedef struct ndmp2_data_start_backup_request ndmp2_data_start_backup_request;

struct ndmp2_data_start_backup_reply {
	ndmp2_error error;
};
typedef struct ndmp2_data_start_backup_reply ndmp2_data_start_backup_reply;

struct ndmp2_name {
	char *name;
	char *dest;
	u_short ssid;
	ndmp2_u_quad fh_info;
};
typedef struct ndmp2_name ndmp2_name;

struct ndmp2_data_start_recover_request {
	ndmp2_mover_addr mover;
	struct {
		u_int env_len;
		ndmp2_pval *env_val;
	} env;
	struct {
		u_int nlist_len;
		ndmp2_name *nlist_val;
	} nlist;
	char *bu_type;
};
typedef struct ndmp2_data_start_recover_request ndmp2_data_start_recover_request;

struct ndmp2_data_start_recover_reply {
	ndmp2_error error;
};
typedef struct ndmp2_data_start_recover_reply ndmp2_data_start_recover_reply;

typedef ndmp2_data_start_recover_request ndmp2_data_start_recover_filehist_request;

typedef ndmp2_data_start_recover_reply ndmp2_data_start_recover_filehist_reply;

struct ndmp2_data_abort_reply {
	ndmp2_error error;
};
typedef struct ndmp2_data_abort_reply ndmp2_data_abort_reply;

struct ndmp2_data_stop_reply {
	ndmp2_error error;
};
typedef struct ndmp2_data_stop_reply ndmp2_data_stop_reply;

struct ndmp2_data_get_env_reply {
	ndmp2_error error;
	struct {
		u_int env_len;
		ndmp2_pval *env_val;
	} env;
};
typedef struct ndmp2_data_get_env_reply ndmp2_data_get_env_reply;

struct ndmp2_notify_data_halted_request {
	ndmp2_data_halt_reason reason;
	char *text_reason;
};
typedef struct ndmp2_notify_data_halted_request ndmp2_notify_data_halted_request;

enum ndmp2_connect_reason {
	NDMP2_CONNECTED = 0,
	NDMP2_SHUTDOWN = 1,
	NDMP2_REFUSED = 2,
};
typedef enum ndmp2_connect_reason ndmp2_connect_reason;

struct ndmp2_notify_connected_request {
	ndmp2_connect_reason reason;
	u_short protocol_version;
	char *text_reason;
};
typedef struct ndmp2_notify_connected_request ndmp2_notify_connected_request;

struct ndmp2_notify_mover_paused_request {
	ndmp2_mover_pause_reason reason;
	ndmp2_u_quad seek_position;
};
typedef struct ndmp2_notify_mover_paused_request ndmp2_notify_mover_paused_request;

struct ndmp2_notify_mover_halted_request {
	ndmp2_mover_halt_reason reason;
	char *text_reason;
};
typedef struct ndmp2_notify_mover_halted_request ndmp2_notify_mover_halted_request;

struct ndmp2_notify_data_read_request {
	ndmp2_u_quad offset;
	ndmp2_u_quad length;
};
typedef struct ndmp2_notify_data_read_request ndmp2_notify_data_read_request;

struct ndmp2_log_log_request {
	char *entry;
};
typedef struct ndmp2_log_log_request ndmp2_log_log_request;

enum ndmp2_debug_level {
	NDMP2_DBG_USER_INFO = 0,
	NDMP2_DBG_USER_SUMMARY = 1,
	NDMP2_DBG_USER_DETAIL = 2,
	NDMP2_DBG_DIAG_INFO = 3,
	NDMP2_DBG_DIAG_SUMMARY = 4,
	NDMP2_DBG_DIAG_DETAIL = 5,
	NDMP2_DBG_PROG_INFO = 6,
	NDMP2_DBG_PROG_SUMMARY = 7,
	NDMP2_DBG_PROG_DETAIL = 8,
};
typedef enum ndmp2_debug_level ndmp2_debug_level;

struct ndmp2_log_debug_request {
	ndmp2_debug_level level;
	char *message;
};
typedef struct ndmp2_log_debug_request ndmp2_log_debug_request;

struct ndmp2_log_file_request {
	char *name;
	u_short ssid;
	ndmp2_error error;
};
typedef struct ndmp2_log_file_request ndmp2_log_file_request;

typedef char *ndmp2_unix_path;

enum ndmp2_unix_file_type {
	NDMP2_FILE_DIR = 0,
	NDMP2_FILE_FIFO = 1,
	NDMP2_FILE_CSPEC = 2,
	NDMP2_FILE_BSPEC = 3,
	NDMP2_FILE_REG = 4,
	NDMP2_FILE_SLINK = 5,
	NDMP2_FILE_SOCK = 6,
};
typedef enum ndmp2_unix_file_type ndmp2_unix_file_type;

struct ndmp2_unix_file_stat {
	ndmp2_unix_file_type ftype;
	u_long mtime;
	u_long atime;
	u_long ctime;
	u_long uid;
	u_long gid;
	u_long mode;
	ndmp2_u_quad size;
	ndmp2_u_quad fh_info;
};
typedef struct ndmp2_unix_file_stat ndmp2_unix_file_stat;

struct ndmp2_fh_unix_path {
	ndmp2_unix_path name;
	ndmp2_unix_file_stat fstat;
};
typedef struct ndmp2_fh_unix_path ndmp2_fh_unix_path;

struct ndmp2_fh_add_unix_path_request {
	struct {
		u_int paths_len;
		ndmp2_fh_unix_path *paths_val;
	} paths;
};
typedef struct ndmp2_fh_add_unix_path_request ndmp2_fh_add_unix_path_request;

struct ndmp2_fh_unix_dir {
	ndmp2_unix_path name;
	u_long node;
	u_long parent;
};
typedef struct ndmp2_fh_unix_dir ndmp2_fh_unix_dir;

struct ndmp2_fh_add_unix_dir_request {
	struct {
		u_int dirs_len;
		ndmp2_fh_unix_dir *dirs_val;
	} dirs;
};
typedef struct ndmp2_fh_add_unix_dir_request ndmp2_fh_add_unix_dir_request;

struct ndmp2_fh_unix_node {
	ndmp2_unix_file_stat fstat;
	u_long node;
};
typedef struct ndmp2_fh_unix_node ndmp2_fh_unix_node;

struct ndmp2_fh_add_unix_node_request {
	struct {
		u_int nodes_len;
		ndmp2_fh_unix_node *nodes_val;
	} nodes;
};
typedef struct ndmp2_fh_add_unix_node_request ndmp2_fh_add_unix_node_request;
#endif /* !NDMOS_OPTION_NO_NDMP2 */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr__ndmp2_u_quad (XDR *, _ndmp2_u_quad*);
extern  bool_t xdr_ndmp2_pval (XDR *, ndmp2_pval*);
extern  bool_t xdr_ndmp2_scsi_device (XDR *, ndmp2_scsi_device*);
extern  bool_t xdr_ndmp2_tape_device (XDR *, ndmp2_tape_device*);
extern  bool_t xdr_ndmp2_error (XDR *, ndmp2_error*);
extern  bool_t xdr_ndmp2_header_message_type (XDR *, ndmp2_header_message_type*);
extern  bool_t xdr_ndmp2_message (XDR *, ndmp2_message*);
extern  bool_t xdr_ndmp2_header (XDR *, ndmp2_header*);
extern  bool_t xdr_ndmp2_connect_open_request (XDR *, ndmp2_connect_open_request*);
extern  bool_t xdr_ndmp2_connect_open_reply (XDR *, ndmp2_connect_open_reply*);
extern  bool_t xdr_ndmp2_auth_type (XDR *, ndmp2_auth_type*);
extern  bool_t xdr_ndmp2_auth_text (XDR *, ndmp2_auth_text*);
extern  bool_t xdr_ndmp2_auth_md5 (XDR *, ndmp2_auth_md5*);
extern  bool_t xdr_ndmp2_auth_data (XDR *, ndmp2_auth_data*);
extern  bool_t xdr_ndmp2_connect_client_auth_request (XDR *, ndmp2_connect_client_auth_request*);
extern  bool_t xdr_ndmp2_connect_client_auth_reply (XDR *, ndmp2_connect_client_auth_reply*);
extern  bool_t xdr_ndmp2_auth_attr (XDR *, ndmp2_auth_attr*);
extern  bool_t xdr_ndmp2_connect_server_auth_request (XDR *, ndmp2_connect_server_auth_request*);
extern  bool_t xdr_ndmp2_connect_server_auth_reply (XDR *, ndmp2_connect_server_auth_reply*);
extern  bool_t xdr_ndmp2_config_get_host_info_reply (XDR *, ndmp2_config_get_host_info_reply*);
extern  bool_t xdr_ndmp2_config_get_butype_attr_request (XDR *, ndmp2_config_get_butype_attr_request*);
extern  bool_t xdr_ndmp2_config_get_butype_attr_reply (XDR *, ndmp2_config_get_butype_attr_reply*);
extern  bool_t xdr_ndmp2_mover_addr_type (XDR *, ndmp2_mover_addr_type*);
extern  bool_t xdr_ndmp2_config_get_mover_type_reply (XDR *, ndmp2_config_get_mover_type_reply*);
extern  bool_t xdr_ndmp2_config_get_auth_attr_request (XDR *, ndmp2_config_get_auth_attr_request*);
extern  bool_t xdr_ndmp2_config_get_auth_attr_reply (XDR *, ndmp2_config_get_auth_attr_reply*);
extern  bool_t xdr_ndmp2_scsi_open_request (XDR *, ndmp2_scsi_open_request*);
extern  bool_t xdr_ndmp2_scsi_open_reply (XDR *, ndmp2_scsi_open_reply*);
extern  bool_t xdr_ndmp2_scsi_close_reply (XDR *, ndmp2_scsi_close_reply*);
extern  bool_t xdr_ndmp2_scsi_get_state_reply (XDR *, ndmp2_scsi_get_state_reply*);
extern  bool_t xdr_ndmp2_scsi_set_target_request (XDR *, ndmp2_scsi_set_target_request*);
extern  bool_t xdr_ndmp2_scsi_set_target_reply (XDR *, ndmp2_scsi_set_target_reply*);
extern  bool_t xdr_ndmp2_scsi_reset_device_reply (XDR *, ndmp2_scsi_reset_device_reply*);
extern  bool_t xdr_ndmp2_scsi_reset_bus_reply (XDR *, ndmp2_scsi_reset_bus_reply*);
extern  bool_t xdr_ndmp2_execute_cdb_request (XDR *, ndmp2_execute_cdb_request*);
extern  bool_t xdr_ndmp2_execute_cdb_reply (XDR *, ndmp2_execute_cdb_reply*);
extern  bool_t xdr_ndmp2_scsi_execute_cdb_request (XDR *, ndmp2_scsi_execute_cdb_request*);
extern  bool_t xdr_ndmp2_scsi_execute_cdb_reply (XDR *, ndmp2_scsi_execute_cdb_reply*);
extern  bool_t xdr_ndmp2_tape_open_mode (XDR *, ndmp2_tape_open_mode*);
extern  bool_t xdr_ndmp2_tape_open_request (XDR *, ndmp2_tape_open_request*);
extern  bool_t xdr_ndmp2_tape_open_reply (XDR *, ndmp2_tape_open_reply*);
extern  bool_t xdr_ndmp2_tape_close_reply (XDR *, ndmp2_tape_close_reply*);
extern  bool_t xdr_ndmp2_tape_get_state_reply (XDR *, ndmp2_tape_get_state_reply*);
extern  bool_t xdr_ndmp2_tape_mtio_op (XDR *, ndmp2_tape_mtio_op*);
extern  bool_t xdr_ndmp2_tape_mtio_request (XDR *, ndmp2_tape_mtio_request*);
extern  bool_t xdr_ndmp2_tape_mtio_reply (XDR *, ndmp2_tape_mtio_reply*);
extern  bool_t xdr_ndmp2_tape_write_request (XDR *, ndmp2_tape_write_request*);
extern  bool_t xdr_ndmp2_tape_write_reply (XDR *, ndmp2_tape_write_reply*);
extern  bool_t xdr_ndmp2_tape_read_request (XDR *, ndmp2_tape_read_request*);
extern  bool_t xdr_ndmp2_tape_read_reply (XDR *, ndmp2_tape_read_reply*);
extern  bool_t xdr_ndmp2_tape_execute_cdb_request (XDR *, ndmp2_tape_execute_cdb_request*);
extern  bool_t xdr_ndmp2_tape_execute_cdb_reply (XDR *, ndmp2_tape_execute_cdb_reply*);
extern  bool_t xdr_ndmp2_mover_state (XDR *, ndmp2_mover_state*);
extern  bool_t xdr_ndmp2_mover_pause_reason (XDR *, ndmp2_mover_pause_reason*);
extern  bool_t xdr_ndmp2_mover_halt_reason (XDR *, ndmp2_mover_halt_reason*);
extern  bool_t xdr_ndmp2_mover_get_state_reply (XDR *, ndmp2_mover_get_state_reply*);
extern  bool_t xdr_ndmp2_mover_mode (XDR *, ndmp2_mover_mode*);
extern  bool_t xdr_ndmp2_mover_tcp_addr (XDR *, ndmp2_mover_tcp_addr*);
extern  bool_t xdr_ndmp2_mover_addr (XDR *, ndmp2_mover_addr*);
extern  bool_t xdr_ndmp2_mover_listen_request (XDR *, ndmp2_mover_listen_request*);
extern  bool_t xdr_ndmp2_mover_listen_reply (XDR *, ndmp2_mover_listen_reply*);
extern  bool_t xdr_ndmp2_mover_set_record_size_request (XDR *, ndmp2_mover_set_record_size_request*);
extern  bool_t xdr_ndmp2_mover_set_record_size_reply (XDR *, ndmp2_mover_set_record_size_reply*);
extern  bool_t xdr_ndmp2_mover_set_window_request (XDR *, ndmp2_mover_set_window_request*);
extern  bool_t xdr_ndmp2_mover_set_window_reply (XDR *, ndmp2_mover_set_window_reply*);
extern  bool_t xdr_ndmp2_mover_continue_reply (XDR *, ndmp2_mover_continue_reply*);
extern  bool_t xdr_ndmp2_mover_abort_reply (XDR *, ndmp2_mover_abort_reply*);
extern  bool_t xdr_ndmp2_mover_stop_reply (XDR *, ndmp2_mover_stop_reply*);
extern  bool_t xdr_ndmp2_mover_read_request (XDR *, ndmp2_mover_read_request*);
extern  bool_t xdr_ndmp2_mover_read_reply (XDR *, ndmp2_mover_read_reply*);
extern  bool_t xdr_ndmp2_mover_close_reply (XDR *, ndmp2_mover_close_reply*);
extern  bool_t xdr_ndmp2_data_operation (XDR *, ndmp2_data_operation*);
extern  bool_t xdr_ndmp2_data_state (XDR *, ndmp2_data_state*);
extern  bool_t xdr_ndmp2_data_halt_reason (XDR *, ndmp2_data_halt_reason*);
extern  bool_t xdr_ndmp2_data_get_state_reply (XDR *, ndmp2_data_get_state_reply*);
extern  bool_t xdr_ndmp2_data_start_backup_request (XDR *, ndmp2_data_start_backup_request*);
extern  bool_t xdr_ndmp2_data_start_backup_reply (XDR *, ndmp2_data_start_backup_reply*);
extern  bool_t xdr_ndmp2_name (XDR *, ndmp2_name*);
extern  bool_t xdr_ndmp2_data_start_recover_request (XDR *, ndmp2_data_start_recover_request*);
extern  bool_t xdr_ndmp2_data_start_recover_reply (XDR *, ndmp2_data_start_recover_reply*);
extern  bool_t xdr_ndmp2_data_start_recover_filehist_request (XDR *, ndmp2_data_start_recover_filehist_request*);
extern  bool_t xdr_ndmp2_data_start_recover_filehist_reply (XDR *, ndmp2_data_start_recover_filehist_reply*);
extern  bool_t xdr_ndmp2_data_abort_reply (XDR *, ndmp2_data_abort_reply*);
extern  bool_t xdr_ndmp2_data_stop_reply (XDR *, ndmp2_data_stop_reply*);
extern  bool_t xdr_ndmp2_data_get_env_reply (XDR *, ndmp2_data_get_env_reply*);
extern  bool_t xdr_ndmp2_notify_data_halted_request (XDR *, ndmp2_notify_data_halted_request*);
extern  bool_t xdr_ndmp2_connect_reason (XDR *, ndmp2_connect_reason*);
extern  bool_t xdr_ndmp2_notify_connected_request (XDR *, ndmp2_notify_connected_request*);
extern  bool_t xdr_ndmp2_notify_mover_paused_request (XDR *, ndmp2_notify_mover_paused_request*);
extern  bool_t xdr_ndmp2_notify_mover_halted_request (XDR *, ndmp2_notify_mover_halted_request*);
extern  bool_t xdr_ndmp2_notify_data_read_request (XDR *, ndmp2_notify_data_read_request*);
extern  bool_t xdr_ndmp2_log_log_request (XDR *, ndmp2_log_log_request*);
extern  bool_t xdr_ndmp2_debug_level (XDR *, ndmp2_debug_level*);
extern  bool_t xdr_ndmp2_log_debug_request (XDR *, ndmp2_log_debug_request*);
extern  bool_t xdr_ndmp2_log_file_request (XDR *, ndmp2_log_file_request*);
extern  bool_t xdr_ndmp2_unix_path (XDR *, ndmp2_unix_path*);
extern  bool_t xdr_ndmp2_unix_file_type (XDR *, ndmp2_unix_file_type*);
extern  bool_t xdr_ndmp2_unix_file_stat (XDR *, ndmp2_unix_file_stat*);
extern  bool_t xdr_ndmp2_fh_unix_path (XDR *, ndmp2_fh_unix_path*);
extern  bool_t xdr_ndmp2_fh_add_unix_path_request (XDR *, ndmp2_fh_add_unix_path_request*);
extern  bool_t xdr_ndmp2_fh_unix_dir (XDR *, ndmp2_fh_unix_dir*);
extern  bool_t xdr_ndmp2_fh_add_unix_dir_request (XDR *, ndmp2_fh_add_unix_dir_request*);
extern  bool_t xdr_ndmp2_fh_unix_node (XDR *, ndmp2_fh_unix_node*);
extern  bool_t xdr_ndmp2_fh_add_unix_node_request (XDR *, ndmp2_fh_add_unix_node_request*);

#else /* K&R C */
extern bool_t xdr__ndmp2_u_quad ();
extern bool_t xdr_ndmp2_pval ();
extern bool_t xdr_ndmp2_scsi_device ();
extern bool_t xdr_ndmp2_tape_device ();
extern bool_t xdr_ndmp2_error ();
extern bool_t xdr_ndmp2_header_message_type ();
extern bool_t xdr_ndmp2_message ();
extern bool_t xdr_ndmp2_header ();
extern bool_t xdr_ndmp2_connect_open_request ();
extern bool_t xdr_ndmp2_connect_open_reply ();
extern bool_t xdr_ndmp2_auth_type ();
extern bool_t xdr_ndmp2_auth_text ();
extern bool_t xdr_ndmp2_auth_md5 ();
extern bool_t xdr_ndmp2_auth_data ();
extern bool_t xdr_ndmp2_connect_client_auth_request ();
extern bool_t xdr_ndmp2_connect_client_auth_reply ();
extern bool_t xdr_ndmp2_auth_attr ();
extern bool_t xdr_ndmp2_connect_server_auth_request ();
extern bool_t xdr_ndmp2_connect_server_auth_reply ();
extern bool_t xdr_ndmp2_config_get_host_info_reply ();
extern bool_t xdr_ndmp2_config_get_butype_attr_request ();
extern bool_t xdr_ndmp2_config_get_butype_attr_reply ();
extern bool_t xdr_ndmp2_mover_addr_type ();
extern bool_t xdr_ndmp2_config_get_mover_type_reply ();
extern bool_t xdr_ndmp2_config_get_auth_attr_request ();
extern bool_t xdr_ndmp2_config_get_auth_attr_reply ();
extern bool_t xdr_ndmp2_scsi_open_request ();
extern bool_t xdr_ndmp2_scsi_open_reply ();
extern bool_t xdr_ndmp2_scsi_close_reply ();
extern bool_t xdr_ndmp2_scsi_get_state_reply ();
extern bool_t xdr_ndmp2_scsi_set_target_request ();
extern bool_t xdr_ndmp2_scsi_set_target_reply ();
extern bool_t xdr_ndmp2_scsi_reset_device_reply ();
extern bool_t xdr_ndmp2_scsi_reset_bus_reply ();
extern bool_t xdr_ndmp2_execute_cdb_request ();
extern bool_t xdr_ndmp2_execute_cdb_reply ();
extern bool_t xdr_ndmp2_scsi_execute_cdb_request ();
extern bool_t xdr_ndmp2_scsi_execute_cdb_reply ();
extern bool_t xdr_ndmp2_tape_open_mode ();
extern bool_t xdr_ndmp2_tape_open_request ();
extern bool_t xdr_ndmp2_tape_open_reply ();
extern bool_t xdr_ndmp2_tape_close_reply ();
extern bool_t xdr_ndmp2_tape_get_state_reply ();
extern bool_t xdr_ndmp2_tape_mtio_op ();
extern bool_t xdr_ndmp2_tape_mtio_request ();
extern bool_t xdr_ndmp2_tape_mtio_reply ();
extern bool_t xdr_ndmp2_tape_write_request ();
extern bool_t xdr_ndmp2_tape_write_reply ();
extern bool_t xdr_ndmp2_tape_read_request ();
extern bool_t xdr_ndmp2_tape_read_reply ();
extern bool_t xdr_ndmp2_tape_execute_cdb_request ();
extern bool_t xdr_ndmp2_tape_execute_cdb_reply ();
extern bool_t xdr_ndmp2_mover_state ();
extern bool_t xdr_ndmp2_mover_pause_reason ();
extern bool_t xdr_ndmp2_mover_halt_reason ();
extern bool_t xdr_ndmp2_mover_get_state_reply ();
extern bool_t xdr_ndmp2_mover_mode ();
extern bool_t xdr_ndmp2_mover_tcp_addr ();
extern bool_t xdr_ndmp2_mover_addr ();
extern bool_t xdr_ndmp2_mover_listen_request ();
extern bool_t xdr_ndmp2_mover_listen_reply ();
extern bool_t xdr_ndmp2_mover_set_record_size_request ();
extern bool_t xdr_ndmp2_mover_set_record_size_reply ();
extern bool_t xdr_ndmp2_mover_set_window_request ();
extern bool_t xdr_ndmp2_mover_set_window_reply ();
extern bool_t xdr_ndmp2_mover_continue_reply ();
extern bool_t xdr_ndmp2_mover_abort_reply ();
extern bool_t xdr_ndmp2_mover_stop_reply ();
extern bool_t xdr_ndmp2_mover_read_request ();
extern bool_t xdr_ndmp2_mover_read_reply ();
extern bool_t xdr_ndmp2_mover_close_reply ();
extern bool_t xdr_ndmp2_data_operation ();
extern bool_t xdr_ndmp2_data_state ();
extern bool_t xdr_ndmp2_data_halt_reason ();
extern bool_t xdr_ndmp2_data_get_state_reply ();
extern bool_t xdr_ndmp2_data_start_backup_request ();
extern bool_t xdr_ndmp2_data_start_backup_reply ();
extern bool_t xdr_ndmp2_name ();
extern bool_t xdr_ndmp2_data_start_recover_request ();
extern bool_t xdr_ndmp2_data_start_recover_reply ();
extern bool_t xdr_ndmp2_data_start_recover_filehist_request ();
extern bool_t xdr_ndmp2_data_start_recover_filehist_reply ();
extern bool_t xdr_ndmp2_data_abort_reply ();
extern bool_t xdr_ndmp2_data_stop_reply ();
extern bool_t xdr_ndmp2_data_get_env_reply ();
extern bool_t xdr_ndmp2_notify_data_halted_request ();
extern bool_t xdr_ndmp2_connect_reason ();
extern bool_t xdr_ndmp2_notify_connected_request ();
extern bool_t xdr_ndmp2_notify_mover_paused_request ();
extern bool_t xdr_ndmp2_notify_mover_halted_request ();
extern bool_t xdr_ndmp2_notify_data_read_request ();
extern bool_t xdr_ndmp2_log_log_request ();
extern bool_t xdr_ndmp2_debug_level ();
extern bool_t xdr_ndmp2_log_debug_request ();
extern bool_t xdr_ndmp2_log_file_request ();
extern bool_t xdr_ndmp2_unix_path ();
extern bool_t xdr_ndmp2_unix_file_type ();
extern bool_t xdr_ndmp2_unix_file_stat ();
extern bool_t xdr_ndmp2_fh_unix_path ();
extern bool_t xdr_ndmp2_fh_add_unix_path_request ();
extern bool_t xdr_ndmp2_fh_unix_dir ();
extern bool_t xdr_ndmp2_fh_add_unix_dir_request ();
extern bool_t xdr_ndmp2_fh_unix_node ();
extern bool_t xdr_ndmp2_fh_add_unix_node_request ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NDMP2_H_RPCGEN */
