
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python module
#
# (C) 2002 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for testing idf
#
# ----------------------------------------------------------

# changed 2002-08-11

# import advas module
import advas

# a line of text
line1 = "the shop opens at eight. it is still closed. do you like to wait here?"
line2 = "the shop is not here. cross the street and turn left before school."
line3 = "our daughter is not at home. she is at school."
line4 = "for better or worse, this will never end. what a shame for us."
line5 = "nobody knows why he did so. he used to work at school."
line6 = "the last sentence in this book was underlined. one page was missing."
line7 = line6
print line1
print line2
print line3
print line4
print line5
print line6 + "\n"

# calculate tf for each text
tf1 = advas.tf(line1)
tf2 = advas.tf(line2)
tf3 = advas.tf(line3)
tf4 = advas.tf(line4)
tf5 = advas.tf(line5)
tf6 = advas.tf(line6)

# create a wordlist for calculating idf
idf_calc = advas.merge_lists_idf(tf1, tf2, tf3, tf4, tf5, tf6, tf6)

# calc idf
idf_calc_2 = advas.idf(7, idf_calc)

# output each item and its idf
key = idf_calc_2.keys()
for item in key:
	print '%-20s (%1d) : %f' % (item, idf_calc[item], idf_calc_2[item])



