/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.action;

import com.acgvision.core.ws.Average;
import com.acgvision.core.ws.Monitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.log4j.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration.Node;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Averager {

    private static final Logger logger = Logger.getLogger(Averager.class);
    private HierarchicalINIConfiguration configFile;
    private static final String section = "Averages";

    public Averager(HierarchicalINIConfiguration c) {
        this.configFile = c;
    }

/**
 * Fonction de sauvegarde de la valeur mesurée
 * @param m
 * @param value
 */
    public void save(Monitor m, int value) {
        if (m != null && this.configFile != null) {
            int MaxValues = 0;
            Iterator<Average> a = m.getAverages().iterator();
            int n ;
            while (a.hasNext()) {
                n = a.next().getQuantity();
                if (n > MaxValues) {
                    MaxValues = n;
                }
            }

            if (MaxValues != 0) {
                try {

                    String key = m.getId().toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Saving value for average with key" + key);
                        logger.debug("Max number remembered" + MaxValues);
                    }
                    String l = null;
                    if (!configFile.getSection(section).isEmpty()) {
                        if (configFile.getSection(section).containsKey(key)) {
                            // try{
                            Object o = configFile.getSection(section).getProperty(key);
                            if (o instanceof Integer) {
                                logger.debug("C'est un entier!!!");
                                l = ((Integer) o).toString();
                            } else {
                                if (o instanceof String) {
                                    logger.debug("C'est un string!!!");
                                    l = (String) o;
                                }
                            }
                            //}catch( org.apache.commons.configuration.ConversionException ex){
                            //    logger.error(ex);
                            //}
                        }
                    } else {
                        if (logger.isInfoEnabled()) {
                            logger.info("Section nulle");
                        }
                    }
                    if (l == null) {//la section n'existe pas
                        if (logger.isInfoEnabled()) {
                            logger.info("First Value to be save in section " + section);
                        }
                        List<Node> nodes = new ArrayList<Node>();//on crée la section
                        nodes.add(new Node(section));
                        configFile.addNodes(section, nodes);
                        String strValue = String.valueOf(value);
                        configFile.getSection(section).addProperty(key, strValue);//on ajoute la valeur
                        logger.info("Enregistrement du fichier de config.");
                        configFile.save();//sauvegarde
                    } else {
                        l = l + ";" + Integer.toString(value);//ajout en queue

                        while (l.split(";").length > MaxValues) {
                            l = l.substring(l.indexOf(";") + 1, l.length());//on enleve la premiere valeur(on ajoute en queue)
                        }
                        configFile.getSection(section).setProperty(key, l);

                        if (logger.isInfoEnabled()) {
                            logger.info("Enregistrement du fichier de config.");
                        }
                        configFile.save();
                    }
                } catch (ConfigurationException ex) {
                    logger.error(ex);
                }
            }
        }
    }

    /**
     * Averages values from the config file
     * @param n number of values needed for average
     * @param monitorId
     * @return average value
     */
    protected int avg(int n, String monitorId) {
        if (configFile.getSection(section) != null) {
            if (n < 0) {
                return -1;
            }

            if (configFile.getSection(section).containsKey(monitorId)) {
                String values = configFile.getSection(section).getString(monitorId);
                //logger.debug("values = " + values);
                String[] v = values.split(";");
                if (v.length <= 0) {
                    return -1;
                }
//                int somme = 0;
                //On contrôle si le nombre des valeurs est supérieur au diviseur de la moyenne
//                if (v.length > n) {

                double somme = 0;
                //on commence à la dernière mesure
                int i = (v.length - 1);
                int nombrevaleurs = 0;
                //String strvaleur = null;
                int valeur = v.length;
                while (i >= 0 && n > nombrevaleurs) {
                  //  strvaleur = v[i];
                   // logger.debug("strvaleur :" + strvaleur);
                    valeur = Integer.parseInt(v[i]);
                    //logger.debug("valeur :" + valeur);
                    somme += valeur;
                    //logger.debug("somme :" + somme);
                    i--;
                    nombrevaleurs++;
                }
                double moyenne = somme / nombrevaleurs;
                if (moyenne > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int) moyenne;
//                } else {
//                    for (int i = 0; i < v.length; i++) {//on ajoute toutes les valeurs
//                        somme += Integer.parseInt(v[i]);
//                    }
//                    return somme / v.length;
//                }
            } else {
                logger.error("key " + monitorId + " does not exist.");
                return -1;
            }
        } else {
            logger.error("section" + section + " does not exist.");
            return -1;
        }
    }

    /**
     * Checks wether the average value is higher then the limit.
     * @param a average
     * @param m monitor
     * @return true if this is an alert value or false in case of error
     */
    public boolean check(Average a, Monitor m) {
        if (a == null || m == null) {
            return false;
        }
        if (m.getId() == null) {
            return false;
        }
        if (a.getQuantity() <= 0) {
            return false;
        }
        //int limit = a.getValue();
        int n = a.getQuantity();
        int avg = avg(n, m.getId().toString());
        if (logger.isDebugEnabled()) {
            logger.debug(m + " - " + a + " average = " + avg);
            logger.debug(m + " - " + a + " limit = " + a.getValue());
        }
        if (a.isHigh()) {
            return (a.getValue() < avg);
        } else {
            return (a.getValue() > avg);
        }
    }
}
