// $Id: StructuredPushSupplier.cpp 76626 2007-01-26 13:50:03Z elliott_c $

#include "orbsvcs/Notify/Structured/StructuredPushSupplier.h"

ACE_RCSID(RT_Notify, TAO_Notify_StructuredPushSupplier, "$Id: StructuredPushSupplier.cpp 76626 2007-01-26 13:50:03Z elliott_c $")
#include "orbsvcs/Notify/Properties.h"

TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_Notify_StructuredPushSupplier::TAO_Notify_StructuredPushSupplier (TAO_Notify_ProxyConsumer* proxy)
  :TAO_Notify_Supplier (proxy)
{
}

TAO_Notify_StructuredPushSupplier::~TAO_Notify_StructuredPushSupplier ()
{
}

void
TAO_Notify_StructuredPushSupplier::init (CosNotifyComm::StructuredPushSupplier_ptr push_supplier)
{
  // TODO: verify single init call
  // push_supplier is optional
  this->push_supplier_ = CosNotifyComm::StructuredPushSupplier::_duplicate (push_supplier);
  this->subscribe_ = CosNotifyComm::NotifySubscribe::_duplicate (push_supplier);
}

void
TAO_Notify_StructuredPushSupplier::release (void)
{
  delete this;
  //@@ inform factory
}

ACE_CString
TAO_Notify_StructuredPushSupplier::get_ior (void) const
{
  ACE_CString result;
  CORBA::ORB_var orb = TAO_Notify_PROPERTIES::instance()->orb();
  try
  {
    CORBA::String_var ior = orb->object_to_string(this->push_supplier_.in());
    result = static_cast<const char*> (ior.in ());
  }
  catch (const CORBA::Exception&)
  {
    result.fast_clear();
  }
  return result;
}

TAO_END_VERSIONED_NAMESPACE_DECL
