/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace@gnome.org>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#ifndef _ABISCAN_SINK_H_
#define _ABISCAN_SINK_H_

#include <glib-object.h>
#include <gnome-scan-sink.h>

G_BEGIN_DECLS

#define ABISCAN_TYPE_SINK             (abiscan_sink_get_type ())
#define ABISCAN_SINK(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), ABISCAN_TYPE_SINK, AbiscanSink))
#define ABISCAN_SINK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), ABISCAN_TYPE_SINK, AbiscanSinkClass))
#define ABISCAN_IS_SINK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ABISCAN_TYPE_SINK))
#define ABISCAN_IS_SINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), ABISCAN_TYPE_SINK))
#define ABISCAN_SINK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), ABISCAN_TYPE_SINK, AbiscanSinkClass))

typedef struct _AbiscanSinkClass AbiscanSinkClass;
typedef struct _AbiscanSink AbiscanSink;

struct _AbiscanSinkClass
{
	GnomeScanSinkClass parent_class;
};

struct _AbiscanSink
{
	GnomeScanSink parent_instance;
	
	gint	count;
	gchar	*filename;
	gchar	*suffix;
};

GType abiscan_sink_get_type (void) G_GNUC_CONST;
void abiscan_sink_register_type (GTypeModule *module);
GnomeScanSink* abiscan_sink_new ();

G_END_DECLS

#endif /* _ABISCAN_SINK_H_ */
