#include "rpggame.h"

namespace rpgobj
{
	vector <dynlightcache> lights;
	vector<projeffect *> effects;

	VARFP(rpgobjupdatedist, 64, 512, 4096,
		if(game::rpgobjdist > rpgobjupdatedist)
			game::rpgobjdist = rpgobjupdatedist;
	);

	void preload()
	{
		loopv(effects)
		{
			if(effects[i]->mdl)
			{
				preloadmodel(effects[i]->mdl);
			}
		}
	}

	enum
	{
		PT_FAST = 1,
	};

	void testproj(int *flags)
	{
		rpgchar *d = game::player1->getchar();
		if(!d || !effects.length()) return;

		int speed = 25 + rnd((*flags &PT_FAST) ? 9976 : 976);
		int grav = -500 + rnd(1001);
		int effect = rnd(effects.length());
		int radius = 16 + rnd(112);
		conoutf("creating dummy projectile; speed %i gravity %i effect %i radius %i", speed, grav, effect, radius);

		projectile *p = new projectile(NULL);
		d->projs.add(p);

		vec dir;
		vecfromyawpitch(game::player1->yaw, game::player1->pitch, 1, 0, p->d);
		p->o = p->lastemit = vec(game::player1->o).add(vec(p->d).mul(4));
		p->speed = speed;
		p->gravity = grav;
		p->effect = effect;
		p->radius = radius;

		//the final touch, add the player's velocity to the projectile
		p->d.add(vec(game::player1->vel).div(p->speed)).add(vec(game::player1->falling).div(p->speed));
	}
	COMMAND(testproj, "i");

	//this returns the value need to level up from this level
	int calcexp(int level)
	{
		//it's just a guassian calculation, this works for all whole numbers
		//this simply counts up all numbers from 0 to n
		return 1000 * (level * (level + 1) / 2);
	}

	void worlduse(rpgent *d, rpgent *s)
	{
		if(!d || d->state != CS_ALIVE || !s || gui::guisopen()) return;
		if(s->etype == ENT_CHAR && s->state==CS_DEAD)
		{
			conoutf("entity is dead, open loot screen");
			return;
		}
		if(s->interact)
		{
			selected = s;
			defformatstring(ds)("%i", getident(d));
			alias("rpginterract", ds);

			formatstring(ds)("%i", getident(s));
			alias("rpgself", ds);

			if(s->interact)
				execute(s->interact);
			return;
		}
	}
	ICOMMAND(worlduse, "", (), worlduse(game::player1, game::hover));

	void adddynlights()
	{
		//the colour vec must have a magnitude above 64 (or else it's too dark to make an impression)
		//the radius must be greater than 32,or else it's too small to really see
		//exceptions are allowed, they just put greater burdens (and we're limited to 5 dynlights)
		//adddynlight(const vec &o, float radius, const vec &color, int fade = 0, int peak = 0, int flags = 0, float initradius = 0, const vec &initcolor = vec(0, 0, 0), physent *owner = NULL);
		loopv(game::rpgobjs)
		{
			rpgchar *d = game::rpgobjs[i]->getchar();
			if(!d)
				continue;
			loopvj(d->projs)
				d->projs[j]->addlight();

		}
		loopv(lights)
		{
			dynlightcache &l = lights[i];
			adddynlight(l.o, l.rad, l.col, l.fade, l.peak, l.flags, l.initrad, l.initcol);
		}
		lights.setsizenodelete(0);
	}

	void applyeffects(rpgent *victim, rpgent *weapon, rpgent *attacker)
	{
		if(!victim || victim->etype != ENT_CHAR || victim->state != CS_ALIVE|| !weapon || !attacker || attacker->etype != ENT_CHAR) return;
		float multiplier = attacker->geteffectmul(*weapon);

		loopv(weapon->effects)
		{
			status &s = *weapon->effects[i];
			victim->effects.add(new status(s.type, s.strength * multiplier, s.duration * multiplier, s.resists));
		}
	}

	void playdeatheffect(vec o, projeffect *sfx, int radius, vec dir = vec(0, 0, 1), rpgent *wep = NULL)
	{
		bool limit = false;
		if(wep && wep->etype == ENT_SPELL && wep->getspell()->type == STYPE_CONE) limit = true;

		switch(sfx->deathpart)
		{
			case PART_EXPLOSION:
			case PART_EXPLOSION_NO_GLARE:
				particle_fireball(o, radius, sfx->deathpart, sfx->deathfade, sfx->deathpartcol, 0);
				break;
			case PART_STREAK:
			case PART_LIGHTNING:
			{
				loopi(limit ? 2 : 75)
				{
					vec offset = vec((rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f).normalize().mul(rnd(111) * radius / 100.0f).add(o);
					vec offset2 = vec((rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f, (rnd(201) - 100)/100.0f).normalize().mul(rnd(111) * radius / 100.0f).add(o);

					particle_flare(offset, offset2, sfx->deathfade, sfx->deathpart, sfx->deathpartcol, sfx->deathpartsize);
				}
				break;
			}
			default:
				particle_splash(sfx->deathpart, limit ? 3 : 150, sfx->deathfade, o, sfx->deathpartcol, sfx->deathpartsize, radius, sfx->gravity ? sfx->gravity : 200);
				break;
		}

		if(sfx->deathdecal >= 0) adddecal(
			sfx->deathdecal,
			o,
			dir.neg(),
			radius,
			bvec(
				(sfx->deathpartcol<<16)&0xFF,
				(sfx->deathpartcol<<8)&0xFF,
				(sfx->deathpartcol&0xFF)
			)
		);

		if(sfx->flags & PFX_DYNLIGHT)
		{
			vec colour = vec((sfx->lightcolour >> 16) &0xFF, (sfx->lightcolour >> 8) &0xFF, sfx->lightcolour&0xFF);
			if(colour.magnitude() >= 64)
			{
				if(sfx->lightcolour < 0) colour.div(-256.0f); //shadow light
				else colour.div(256.0f);

				vec initcolour = vec((sfx->deathlightinitcol >> 16) &0xFF, (sfx->deathlightinitcol >> 8) &0xFF, sfx->deathlightinitcol&0xFF);
				if(sfx->deathlightinitcol < 0) initcolour.div(-256.0f);
				else initcolour.div(256.0f);

				lights.add(dynlightcache(o, sfx->lightradius * 2, initcolour, sfx->deathlightfade, sfx->deathlightfade/2, sfx->deathlightflags, sfx->lightradius, colour));
			}
		}
	}

	void updateprojs(rpgent *d)
	{
		rpgchar *dc = (rpgchar *) d->subtype; //function only to be called for ENT_CHAR

		loopvrev(dc->projs)
		{
			projectile *p = dc->projs[i];

			if(p->deleted)
			{
				//deletion is delayed 1 frame to allow the trails to be drawn completely
				delete p;
				dc->projs.remove(i);
				continue;
			}

			float delta = p->speed * curtime * p->d.magnitude() / 1000.0f;
			vec pos;
			float newdelta = raycubepos(p->o, p->d, pos, 0, RAY_CLIPMAT|RAY_ALPHAPOLY);

			if(delta >= newdelta)
			{
				p->deleted = true;
			}
			else
			{
				pos = vec(p->o).add(vec(p->d).mul(delta).div(p->d.magnitude()));
			}

			rpgent *victim = (rpgent *) game::intersectclosest(p->o, pos, d, newdelta, 1); //returns collisions that are <= 1x the geom collision
			if(victim)
			{
				p->deleted = true;
				pos.sub(vec(p->d).mul(1-newdelta).div(p->d.magnitude()));
			}

			p->o = pos;

			//TODO a check for single collision projectiles only
			if(p->deleted)
			{
				projeffect *sfx = effects.inrange(p->effect) ? effects[p->effect] : NULL;

				loopvj(game::rpgobjs)
				{
					rpgent *v = game::rpgobjs[j];

					delta = v->o.dist(p->o); ///reuse delta for distance
					if(delta < p->radius || v == victim)
					{
						rpgent *v = game::rpgobjs[j];
						if(v->etype == ENT_CHAR) applyeffects(v, p->weapon, d);

						//kickback
						pos = vec(v->o).sub(vec(0,0,v->eyeheight/2)).sub(p->o); pos.normalize(); ///reuse pos for kickback

						delta = max((float)0.1f, delta);
						pos.mul(sfx->kickback * p->radius/(delta * delta));
						v->vel.add(vec(pos).mul(5.0f));

						if(v->ragdoll) ragdolladdvel(v, vec(pos).div(10.0f));
					}
				}

				if(sfx)
					playdeatheffect(p->o, sfx, p->radius, p->d, p->weapon);

				continue;
			}

			if(p->gravity)
			{
				p->d.z -= (p->gravity * curtime) / (1000.0f * p->speed);
			}
		}
	}

	/*void doattack(rpgent *d, rpgent *item);
	{
		if(!item)

	}*/

	void addspellprojectile(rpgent *d, rpgent *s, bool fuzzy = false)
	{
		if(!d || !s) return;

		rpgspell *ss = s->getspell();
		rpgchar *dc = d->getchar();

		if(!effects.inrange(ss->effect)) return;

		projeffect *sfx = effects[ss->effect];

		projectile *p = dc->projs.add(new projectile(s));
		vecfromyawpitch(
			d->yaw + (fuzzy ? (30 * (rnd(201) - 100) / 100) : 0),
			d->pitch + (fuzzy ? (5 * (rnd(201) - 100) / 100) : 0),
			1,
			0,
			p->d
		);

		p->o = vec(p->d).mul(d->radius);
		p->o.add(d->o);
		p->lastemit = p->o;

		p->d.add(vec(d->vel).add(d->falling).div(sfx->basevel));
		p->effect = ss->effect;
		p->radius = ss->range;
		p->gravity = ss->gravity;
		p->speed = sfx->basevel;
	}

	void attack(rpgent *d)
	{
		rpgchar *dc = d->getchar();
		if(dc->firstattack)
		{
			//who said they're not allowed to be ambi dextrous? :D
			rpgent *rhand = dc->selected[EQUIP_RHAND],
				*lhand = dc->selected[EQUIP_LHAND];
			if(rhand && lhand)
			{
				//TODO, prevent this case
				if(rhand->getitem()->type == ITYPE_RANGED) rhand = NULL; //bows require two hands
				if(lhand->getitem()->type == ITYPE_RANGED) lhand = NULL;
				conoutf("warning: bow and melee equipped, bows need two hands");
			}

		}
		else if(dc->secondattack)
		{
			//TODO cast delay
			if(!dc->selectedspell) return;
			rpgent *s = dc->selectedspell;
			rpgspell *ss = s->getspell();

			if(dc->lastaction + ss->cooldown > lastmillis || dc->mana < ss->cost) return;
			dc->lastaction = lastmillis;
			dc->mana -= ss->cost;

			switch(ss->type)
			{
				case STYPE_TARGET:
					addspellprojectile(d, s);
					break;
				case STYPE_CONE:
					loopi(50) addspellprojectile(d, s, true);
					break;
				case STYPE_SELF:
					loopv(game::rpgobjs)
					{
						if(game::rpgobjs[i]->o.dist(d->o) <= ss->range)
							applyeffects(game::rpgobjs[i], s, d);
					}
					if(effects.inrange(ss->effect))
						playdeatheffect(d->abovehead(), effects[ss->effect], ss->range, vec(0,0,1), s);
					break;
				default:
					break;
			}
		}
	}

	void update()
	{
		loopv(game::rpgobjs)
		{
			rpgent *r = game::rpgobjs[i];
			r->temp.dist = r->o.dist(game::player1->o);

			if(r->temp.dist <= rpgobjupdatedist)
			{
				switch(r->etype)
				{
					case ENT_CHAR:
					{
						rpgchar *rc = r->getchar();

						if(!i)
							entities::update(r);

						r->temp.fade = 1;
						if(r->state==CS_DEAD)
						{
							r->move = r->strafe = 0;
						}
						else if(r->state != CS_EDITING && rc->health <= 0) r->die();

						if(r->state==CS_DEAD && r->ragdoll) moveragdoll(r);
						else
						{
							if(r->ragdoll) cleanragdoll(r);
							moveplayer(r, i ? 2 : 10, r->state != CS_DEAD);
						}
						break;
					}
					case ENT_ITEM:
					case ENT_SPELL:
						if(r->move || r->strafe) {r->move = r->strafe = 0;}
						moveplayer(r, 2, false);
						break;
					default:
						break;
				}
			}
			switch(r->etype)
			{
				case ENT_CHAR:
				{
					rpgchar *rc = r->getchar();

					if(r->state!=CS_DEAD)
					{
						rc->attributes = rc->base;
						stats calc = stats(true); //for stats that get overwritten when calcattrs are called
						r->updateeffects(calc, r->effects);
						r->updateinv(calc);
						rc->attributes.limits(); //this is to ensure things arne't chaotic for the below items
						rc->attributes.calcattrs();
						rc->attributes.addall(calc);
						rc->attributes.limits(); //insurance against overwhelmingly kewl lewt

						r->maxspeed = rc->attributes.movespeed;
						r->jumpvel = rc->attributes.jumpvel;

						float recover = min(rc->attributes.healthregen * curtime / 1000.0f, rc->attributes.maxhealth - rc->health);
						rc->health += recover;

						recover = min(rc->attributes.manaregen * curtime / 1000.0f, rc->attributes.maxmana - rc->mana);
						rc->mana += recover;

						attack(r);
					}
					updateprojs(r);
					break;
				}
				case ENT_ITEM:
					r->itemeffects(r->getitem()->owneffects);
					break;
				case ENT_SPELL:
					break;
				case ENT_OBJECT:
					r->itemeffects(r->effects);
					break;
				default:
					break;
			}
		}
	}
};
