/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private String name;
    private static Map unknown_attributes = new HashMap();

    static Unknown[] getUnknownAttributes() {
        Unknown[] unknownArray = new Unknown[unknown_attributes.size()];
        Iterator iterator = unknown_attributes.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            unknownArray[n] = (Unknown)iterator.next();
            ++n;
        }
        unknown_attributes.clear();
        return unknownArray;
    }

    public Unknown(Unknown unknown) {
        this(unknown.getNameIndex(), unknown.getLength(), unknown.getBytes(), unknown.getConstantPool());
    }

    public Unknown(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)-1, n, n2, constantPool);
        this.bytes = byArray;
        this.name = ((ConstantUtf8)constantPool.getConstant(n, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInputStream.readFully(this.bytes);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitUnknown(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.length > 0) {
            dataOutputStream.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final String getName() {
        return this.name;
    }

    public final void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public final String toString() {
        String string;
        if (this.length == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (this.length > 10) {
            byte[] byArray = new byte[10];
            System.arraycopy(this.bytes, 0, byArray, 0, 10);
            string = Utility.toHexString(byArray) + "... (truncated)";
        } else {
            string = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + string + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        Unknown unknown = (Unknown)this.clone();
        if (this.bytes != null) {
            unknown.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, unknown.bytes, 0, this.bytes.length);
        }
        unknown.constant_pool = constantPool;
        return unknown;
    }
}

