/*
 * Decompiled with CFR 0.152.
 */
package spin.demo.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import spin.Spin;
import spin.demo.Assert;
import spin.demo.progress.ProgressBean;
import spin.demo.progress.ProgressBeanImpl;
import spin.off.ListenerSpinOver;

public class PushGUI
extends JPanel
implements PropertyChangeListener {
    private JProgressBar progressBar = new JProgressBar();
    private JButton button = new JButton("Start");
    private ProgressBean progressBean;

    public PushGUI(ProgressBean aProgressBean) {
        this.progressBean = aProgressBean;
        this.progressBean.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.progressBar, "Center");
        this.add((Component)this.button, "South");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if ("Start".equals(PushGUI.this.button.getText())) {
                    PushGUI.this.button.setText("Cancel");
                    PushGUI.this.progressBar.setValue(0);
                    PushGUI.this.progressBean.start();
                    PushGUI.this.button.setText("Start");
                    PushGUI.this.progressBar.setValue(100);
                } else {
                    PushGUI.this.progressBean.cancel();
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Assert.onEDT();
        if ("value".equals(evt.getPropertyName())) {
            double status = (Double)evt.getNewValue();
            this.progressBar.setValue((int)(status * 100.0));
        }
    }

    public static void main(String[] args) {
        Spin.setDefaultOffEvaluator(new ListenerSpinOver());
        ProgressBeanImpl progressBean = new ProgressBeanImpl();
        PushGUI pushGUI = new PushGUI((ProgressBean)Spin.off(progressBean));
        JFrame frame = new JFrame("Pushed progress");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(pushGUI);
        frame.pack();
        frame.setVisible(true);
    }
}

