/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSObjectable;

public class PDTextStream
implements COSObjectable {
    private COSString string;
    private COSStream stream;

    public PDTextStream(COSString str) {
        this.string = str;
    }

    public PDTextStream(String str) {
        this.string = new COSString(str);
    }

    public PDTextStream(COSStream str) {
        this.stream = str;
    }

    public static PDTextStream createTextStream(COSBase base) {
        PDTextStream retval = null;
        if (base instanceof COSString) {
            retval = new PDTextStream((COSString)base);
        } else if (base instanceof COSStream) {
            retval = new PDTextStream((COSStream)base);
        }
        return retval;
    }

    public COSBase getCOSObject() {
        COSBase retval = null;
        retval = this.string == null ? this.stream : this.string;
        return retval;
    }

    public String getAsString() throws IOException {
        String retval = null;
        if (this.string != null) {
            retval = this.string.getString();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            InputStream is = this.stream.getUnfilteredStream();
            while ((amountRead = is.read(buffer)) != -1) {
                out.write(buffer, 0, amountRead);
            }
            retval = new String(out.toByteArray());
        }
        return retval;
    }

    public InputStream getAsStream() throws IOException {
        InputStream retval = null;
        retval = this.string != null ? new ByteArrayInputStream(this.string.getBytes()) : this.stream.getUnfilteredStream();
        return retval;
    }
}

