/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.analysis.NFAState;
import org.antlr.test.BaseTest;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;

public class TestNFAConstruction
extends BaseTest {
    public void testA() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-A->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAB() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A B ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-A->.s3\n.s3-B->.s4\n.s4->:s5\n:s5-EOF->.s6\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorB() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A | B {;} ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s7\n.s2-A->.s3\n.s3->.s4\n.s4->:s5\n.s7->.s8\n.s8-B->.s9\n.s9->.s4\n:s5-EOF->.s6\n";
        this.checkRule(g, "a", expecting);
    }

    public void testRangeOrRange() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : ('a'..'c' 'h' | 'q' 'j'..'l') ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10-'q'->.s11\n.s11-'j'..'l'->.s12\n.s12->.s6\n.s2->.s3\n.s2->.s9\n.s3-'a'..'c'->.s4\n.s4-'h'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n:s7-<EOT>->.s8\n";
        this.checkRule(g, "A", expecting);
    }

    public void testRange() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : 'a'..'c' ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-'a'..'c'->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(g, "A", expecting);
    }

    public void testCharSetInParser() throws Exception {
        Grammar g = new Grammar("grammar P;\na : A|'b' ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-A..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testABorCD() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A B | C D;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10-D->.s11\n.s11->.s5\n.s2-A->.s3\n.s3-B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-C->.s10\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testbA() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b A ;\nb : B ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5-B->.s6\n.s6->:s7\n.s8-A->.s9\n.s9->:s10\n:s10-EOF->.s11\n:s7->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testbA_bC() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b A ;\nb : B ;\nc : b C;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s12->.s13\n.s13-C->.s14\n.s14->:s15\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5-B->.s6\n.s6->:s7\n.s8-A->.s9\n.s9->:s10\n:s10-EOF->.s11\n:s15-EOF->.s16\n:s7->.s12\n:s7->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorEpsilon() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A | ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s7\n.s2-A->.s3\n.s3->.s4\n.s4->:s5\n.s7->.s8\n.s8->.s9\n.s9->.s4\n:s5-EOF->.s6\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAOptional() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A)?;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testNakedAoptional() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A?;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorBthenC() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A | B) C;");
    }

    public void testAplus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A)+;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testNakedAplus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A+;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAplusNonGreedy() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : (options {greedy=false;}:'0'..'9')+ ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-'0'..'9'->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-<EOT>->.s8\n";
        this.checkRule(g, "A", expecting);
    }

    public void testAorBplus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A | B{action})+ ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorBorEmptyPlus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A | B | )+ ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s10->.s13\n.s11-B->.s12\n.s12->.s6\n.s13->.s14\n.s14->.s15\n.s15->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAStar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A)*;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testNestedAstar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A*)*;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s8\n.s14->.s10\n.s2->.s14\n.s2->.s3\n.s3->.s4\n.s4->.s13\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(g, "a", expecting);
    }

    public void testPlusNestedInStar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A+)*;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s10\n.s2->.s13\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(g, "a", expecting);
    }

    public void testStarNestedInPlus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A*)+;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s8\n.s2->.s3\n.s3->.s4\n.s4->.s13\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(g, "a", expecting);
    }

    public void testNakedAstar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A*;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorBstar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (A | B{action})* ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12->.s6\n.s13->.s7\n.s2->.s13\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAorBOptionalSubrule() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : ( A | B )? ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A..B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testPredicatedAorB() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? A | {p2}? B ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10-B->.s11\n.s11->.s5\n.s2-{p1}?->.s3\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-{p2}?->.s10\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testMultiplePredicates() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : {p1}? {p1a}? A | {p2}? B | {p3} b;\nb : {p4}? B ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s9\n.s10-{p2}?->.s11\n.s11-B->.s12\n.s12->.s6\n.s13->.s14\n.s14->.s15\n.s15->.s16\n.s16->.s17\n.s17-{p4}?->.s18\n.s18-B->.s19\n.s19->:s20\n.s2-{p1}?->.s3\n.s21->.s6\n.s3-{p1a}?->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n.s9->.s13\n:s20->.s21\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testSets() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : ( A | B )+ ;\nb : ( A | B{;} )+ ;\nc : (A|B) (A|B) ;\nd : ( A | B )* ;\ne : ( A | B )? ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A..B->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
        expecting = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "b", expecting);
        expecting = ".s0->.s1\n.s1->.s2\n.s2-A..B->.s3\n.s3-A..B->.s4\n.s4->:s5\n:s5-EOF->.s6\n";
        this.checkRule(g, "c", expecting);
        expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A..B->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(g, "d", expecting);
        expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A..B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(g, "e", expecting);
    }

    public void testNotSet() throws Exception {
        Grammar g = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : ~A ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
        String expectingGrammarStr = "1:8: parser grammar P;\na : ~ A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testNotSingletonBlockSet() throws Exception {
        Grammar g = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : ~(A) ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
        String expectingGrammarStr = "1:8: parser grammar P;\na : ~ A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testNotCharSet() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : ~'3' ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : ~ '3' ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testNotBlockSet() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : ~('3'|'b') ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : ~ ('3'|'b');\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testNotSetLoop() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : ~('3')* ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-<EOT>->.s8\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : (~ '3' )* ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testNotBlockSetLoop() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : ~('3'|'b')* ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-<EOT>->.s8\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : (~ ('3'|'b'))* ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testSetsInCombinedGrammarSentToLexer() throws Exception {
        Grammar g = new Grammar("grammar t;\nA : '{' ~('}')* '}';\n");
        String result = g.getLexerGrammar();
        String expecting = "lexer grammar t;\n\n// $ANTLR src \"<string>\" 2\nA : '{' ~('}')* '}';\n";
        TestNFAConstruction.assertEquals((String)result, (String)expecting);
    }

    public void testLabeledNotSet() throws Exception {
        Grammar g = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : t=~A ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
        String expectingGrammarStr = "1:8: parser grammar P;\na : t=~ A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testLabeledNotCharSet() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : t=~'3' ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : t=~ '3' ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testLabeledNotBlockSet() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : t=~('3'|'b') ;\n");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(g, "A", expecting);
        String expectingGrammarStr = "1:7: lexer grammar P;\nA : t=~ ('3'|'b');\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)expectingGrammarStr, (String)g.toString());
    }

    public void testEscapedCharLiteral() throws Exception {
        Grammar g = new Grammar("grammar P;\na : '\\n';");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-'\\n'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testEscapedStringLiteral() throws Exception {
        Grammar g = new Grammar("grammar P;\na : 'a\\nb\\u0030c\\'';");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-'a\\nb\\u0030c\\''->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_RuleBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : 'a'{;}|'b';");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10->.s5\n.s2-{synpred1}?->.s3\n.s3-'a'->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-'b'->.s10\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_RuleSetBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : 'a'|'b';");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-'a'..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_SimpleBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b') ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10-'b'->.s11\n.s11->.s6\n.s2->.s3\n.s2->.s9\n.s3-{synpred1}?->.s4\n.s4-'a'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_SetBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b') ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2-'a'..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_StarBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')* ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s11->.s12\n.s12-{synpred2}?->.s13\n.s13-'b'->.s14\n.s14->.s7\n.s15->.s8\n.s2->.s15\n.s2->.s3\n.s3->.s11\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'->.s6\n.s6->.s7\n.s7->.s3\n.s7->.s8\n.s8->:s9\n:s9-EOF->.s10\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_StarSetBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b')* ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->.s7\n.s2->.s10\n.s2->.s3\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'..'b'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_StarBlock1Alt() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')* ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10->.s7\n.s2->.s10\n.s2->.s3\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_PlusBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')+ ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s11->.s12\n.s12-{synpred2}?->.s13\n.s13-'b'->.s14\n.s14->.s7\n.s2->.s3\n.s3->.s11\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'->.s6\n.s6->.s7\n.s7->.s3\n.s7->.s8\n.s8->:s9\n:s9-EOF->.s10\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_PlusSetBlock() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b')+ ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'..'b'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_PlusBlock1Alt() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')+ ;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-{synpred1}?->.s5\n.s5-'a'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_OptionalBlock2Alts() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')?;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s10-{synpred2}?->.s11\n.s11-'b'->.s12\n.s12->.s6\n.s13->.s6\n.s2->.s3\n.s2->.s9\n.s3-{synpred1}?->.s4\n.s4-'a'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n.s9->.s13\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_OptionalBlock1Alt() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')?;");
        String expecting = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3-{synpred1}?->.s4\n.s4-'a'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(g, "a", expecting);
    }

    public void testAutoBacktracking_ExistingPred() throws Exception {
        Grammar g = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')=> 'a' | 'b';");
        String expecting = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10->.s5\n.s2-{synpred1}?->.s3\n.s3-'a'->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-'b'->.s10\n:s6-EOF->.s7\n";
        this.checkRule(g, "a", expecting);
    }

    private final void checkRule(Grammar g, String rule, String expecting) {
        g.createNFAs();
        NFAState startState = g.getRuleStartState(rule);
        FASerializer serializer = new FASerializer(g);
        String result = serializer.serialize(startState);
        TestNFAConstruction.assertEquals((String)expecting, (String)result);
    }
}

