package org.inria.bmajwatcher.server;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.inria.bmajwatcher.server.data.BankRetriever;

/**
 * Servlet that handles the requests from the client side datasource
 * to retrieve the list of the banks.
 * 
 * @author rsabas
 *
 */
public class BankListingService extends HttpServlet {

	private static final long serialVersionUID = 1L;

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		fetchData(resp.getWriter());
	}
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		fetchData(resp.getWriter());
	}
	
	/**
	 * Retrieves the list of the banks and writes it as an XML message
	 * that follows the format required by <code>RestDataSource</code>.
	 * 
	 * @param out stream where output is written
	 */
	private void fetchData(PrintWriter out) {
		String biomajRoot = getServletContext().getInitParameter("BIOMAJ_ROOT");
		out.write(BankRetriever.getInstance().getBankList(biomajRoot));
		out.flush();
	}
	
	
}
