package org.inria.bmajwatcher.client.ui.bank_editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.inria.bmajwatcher.client.i18n.BmajWatcherConstants;
import org.inria.bmajwatcher.client.services.BankEditingServiceAsync;
import org.inria.bmajwatcher.client.ui.styles.MainCss;
import org.inria.bmajwatcher.client.ui.styles.Resources;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.smartgwt.client.util.SC;

/**
 * Class for bank properties edition.
 * 
 * @author rsabas
 */
public class BankEditorDialog extends DialogBox {

	private static BankEditorDialog instance = new BankEditorDialog();
	
	
	private VerticalPanel miscContent = new VerticalPanel();
	private VerticalPanel initContent = new VerticalPanel();
	private VerticalPanel releaseContent = new VerticalPanel();
	private VerticalPanel downloadContent = new VerticalPanel();
	private VerticalPanel extractContent = new VerticalPanel();
	private VerticalPanel makeReleaseContent = new VerticalPanel();
	private VerticalPanel deploymentContent = new VerticalPanel();
	private VerticalPanel dbContent = new VerticalPanel();
	private VerticalPanel ftpContent = new VerticalPanel();
	private VerticalPanel httpContent = new VerticalPanel();
	
	private DisclosurePanel initPanel = new DisclosurePanel("Initialization");
	private DisclosurePanel removePsPanel = new DisclosurePanel("Remove-processes");
	private DisclosurePanel dbPanel = new DisclosurePanel("Database");
	private DisclosurePanel generalPanel = new DisclosurePanel("Miscellaneous");
	private DisclosurePanel releasePanel = new DisclosurePanel("Release");
	private DisclosurePanel downloadPanel = new DisclosurePanel("Download");
	private DisclosurePanel ftpCfgPanel = new DisclosurePanel("FTP configuration");
	private DisclosurePanel httpCfgPanel = new DisclosurePanel("HTTP configuration");
	private DisclosurePanel extractPanel = new DisclosurePanel("Extract");
	private DisclosurePanel deploymentPanel = new DisclosurePanel("Deployment");
	private DisclosurePanel makeReleasePanel = new DisclosurePanel("Make release");
	
	private VerticalPanel bankPanel = new VerticalPanel();
	private HorizontalPanel hpSelectedBank = new HorizontalPanel();
	
	private ListBox localBankList = new ListBox(false);
	private ListBox remoteBankList = new ListBox(false);
	private ListBox templateList = new ListBox(false);
	private ListBox parentList = new ListBox(false);
	private ListBox propertyListBox = new ListBox(false);
	private ListBox includeList = new ListBox(false);
	
	private HTML lblTemplateDesc = new HTML();
	private Label lblSelectedBank = new Label();
	private MenuBar menuSave = new MenuBar();
	private HorizontalPanel pnlIncludeWarning = new HorizontalPanel();
	private Label lblIncludeWarning = new Label();
	private HorizontalPanel hpIncludeList = new HorizontalPanel();
	
	private Button addInclude = new Button("Add");
	private PushButton removeInclude = new PushButton(new Image("images/edit-delete.png"));
	
	private Map<String, Map<String, String>> currentIncludedFiles = null;
	private Map<String, String> propertyHelp = null;
	private Set<String> stockProps = new TreeSet<String>();
	private String currentFile = "";
	private String selectedBank = "";
	private BankValidator validator = BankValidator.getInstance();
	
	private String type = "";
	private final static String CREATE_NEW_INCLUDE = "Create new include file...";

	private RadioButton radioLoadRemote = new RadioButton("default", "Load from remote :");
	private RadioButton radioEmptyBank = new RadioButton("default", "Create bank from template :");
	private RadioButton radioLoadLocal = new RadioButton("default", "Load from local :");
	
	private ProcessEditor preProcessEditor = new ProcessEditor();
	private ProcessEditor postProcessEditor = new ProcessEditor();
	private ProcessEditor removeProcessEditor = new ProcessEditor();
	
	private CheckBox seeInherited = new CheckBox("See inherited properties");
	private CheckBox override = new CheckBox("Override inherited properties");
	
	private MainCss css = Resources.INSTANCE.mainCss();
	
	private BankEditingServiceAsync server = BankEditingServiceAsync.INSTANCE;
	
	// Bank index for saving
	private int pos;
	
	private BankEditorDialog() {
		super(false, false);
		setHTML("<b>Bank editor</b>");
		
		addStyleName(css.bankEditor());
		
		pnlIncludeWarning.addStyleName(css.warningPanel());
		pnlIncludeWarning.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		Image img = new Image("images/vcs-conflicting.png");
		pnlIncludeWarning.add(img);
		pnlIncludeWarning.setCellWidth(img, "35px");
		pnlIncludeWarning.add(lblIncludeWarning);
		pnlIncludeWarning.setVisible(false);
		
		/*
		 * Gets the mandatory properties list
		 */
		server.getMandatoryProperties(new AsyncCallback<Collection<String>>() {
			
			@Override
			public void onSuccess(Collection<String> result) {
				validator.setMandatoryProps(result);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.warn("Could not retrieve mandatory properties !");
			}
		});
		
		/*
		 * Gets the text bubbles for each property
		 */
		server.getPropertyHelp(new AsyncCallback<Map<String,String>>() {
			
			@Override
			public void onSuccess(Map<String, String> result) {
				propertyHelp = new HashMap<String, String>();
				/*
				 * Adds property type to validator
				 */
				for (String prop : result.keySet()) {
					String[] split = result.get(prop).split("__:__");
					propertyHelp.put(prop, split[0]);
					validator.addType(prop, split[1]);
				}
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.warn("Properties description could not be retrieved !");
			}
		});
		
		/*
		 * Main panels
		 */
		VerticalPanel mainPanel = new VerticalPanel();
		mainPanel.addStyleName(css.bankEditorMainPanel());
//		topPanel.addStyleName(css.bankEditorPanel());
		VerticalPanel topPanel = new VerticalPanel();
		topPanel.setSpacing(3);
		topPanel.addStyleName(css.bankEditorTopPanel());
		final VerticalPanel centerPanel = new VerticalPanel();
		centerPanel.addStyleName(css.bankEditorPanel());
		HorizontalPanel bottomPanel = new HorizontalPanel();

		/*
		 * Options panel
		 */
		final VerticalPanel optionsPanel = new VerticalPanel();
		optionsPanel.addStyleName(css.bankEditorPanel());
		optionsPanel.add(seeInherited);
		optionsPanel.add(override);
		
		hpIncludeList.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		hpIncludeList.setSpacing(3);
		Label includeLabel = new Label("Include files :");
		hpIncludeList.add(includeLabel);
		hpIncludeList.add(includeList);
		addInclude.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				int index = includeList.getSelectedIndex();
				Collection<String> names = new ArrayList<String>();
				String name = "include/" + includeList.getValue(index);
				names.add(name);
				for (int i = 0; i < parentList.getItemCount(); i++) {
					String value = parentList.getItemText(i);
					if (!name.equals(value) && !value.equals("global.properties") && !value.equals(selectedBank))
						names.add(value);
				}
				loadBank(selectedBank.substring(0, selectedBank.lastIndexOf('.')), names);
				if (!name.equals("include/" + CREATE_NEW_INCLUDE))
					includeList.removeItem(index);
			}
		});
		hpIncludeList.add(addInclude);
		
		hpIncludeList.addStyleName(css.includeFilePanel());
		optionsPanel.add(hpIncludeList);
		
		
		/*
		 * Inherited properties options
		 */
		seeInherited.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				if (parentList.getItemCount() > 0) {
					
					Map<String, String> pre = preProcessEditor.getProcessProperties();
					Map<String, String> post = postProcessEditor.getProcessProperties();
					Map<String, String> remove = removeProcessEditor.getProcessProperties();
					
					Map<String, String> ps = new HashMap<String, String>();
					ps.putAll(pre);
					ps.putAll(post);
					ps.putAll(remove);
					validator.setBankProcesses(currentFile, ps);
					
					BankValidator.clearProcesses(currentIncludedFiles.get(currentFile));
					currentIncludedFiles.get(currentFile).putAll(ps);
					
					String value = parentList.getItemText(parentList.getSelectedIndex());
					populateProperties(currentIncludedFiles.get(value));
				}
			}
		});
		override.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				if (parentList.getItemCount() > 0) {
					String value = parentList.getItemText(parentList.getSelectedIndex());
					populateProperties(currentIncludedFiles.get(value));
				}
			}
		});
		
		
		/*
		 * Properties files for a bank
		 */
		VerticalPanel vpOptions = new VerticalPanel();
		vpOptions.addStyleName(css.bankEditorSubPanel());
		HorizontalPanel hpOptions = new HorizontalPanel();
		hpOptions.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		Label filz = new Label("Related files :");
		filz.addStyleName(css.propsParameter());
		hpOptions.add(filz);
		parentList.addStyleName(css.propsParameter());
		hpOptions.add(parentList);
		hpOptions.add(removeInclude);
		/*
		 * Delete selected included file
		 */
		removeInclude.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
//				for (String key : currentIncludedFiles.get(currentFile).keySet()) {
//					validator.removeValue(selectedBank, "inherited:" + key, currentIncludedFiles);
//					currentIncludedFiles.get(selectedBank).remove("inherited:" + key);
//				}
				
				final String name = parentList.getItemText(parentList.getSelectedIndex());
				validator.removeBank(name, currentIncludedFiles);
				currentIncludedFiles.remove(name);
				parentList.removeItem(parentList.getSelectedIndex());
				server.propertiesFileExists(name, new AsyncCallback<Boolean>() {
					
					@Override
					public void onSuccess(Boolean result) {
						if (result)
							includeList.addItem(name.substring(name.indexOf('/') + 1));
					}
					
					@Override
					public void onFailure(Throwable caught) {
						SC.warn("Could not test file existence");
					}
				});
				parentList.setSelectedIndex(0);
				loadChangedFile();
			}
		});
		
		Label lblAddProp = new Label("Add a property :");
		lblAddProp.addStyleName(css.propsParameter());
		hpOptions.add(lblAddProp);
		propertyListBox.addStyleName(css.propsParameter());
		propertyListBox.setEnabled(false);
		hpOptions.add(propertyListBox);
		Button btnAddProp = new Button("Add");
		btnAddProp.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				if (propertyListBox.getItemCount() > 0) {
					addProperty(propertyListBox.getValue(propertyListBox.getSelectedIndex()));
					propertyListBox.removeItem(propertyListBox.getSelectedIndex());
				}
			}
		});
		hpOptions.add(btnAddProp);
		
		
		parentList.addChangeHandler(new ChangeHandler() {
			
			@Override
			public void onChange(ChangeEvent event) {
				loadChangedFile();
			}
		});
		vpOptions.add(hpOptions);
		
		
		/*
		 * Properties panel
		 */
		centerPanel.add(vpOptions);
		
		DisclosurePanel syncPanel = new DisclosurePanel("Synchronization");
		DisclosurePanel postPsPanel = new DisclosurePanel("Post-processes");
		DisclosurePanel prePsPanel = new DisclosurePanel("Pre-processes");
		
		HorizontalPanel preHeader = new HorizontalPanel();
		preHeader.add(prePsPanel.getHeader());
		Image helpPre = new Image("images/help-hint.png");
		helpPre.addStyleName(css.helpIcon());
		helpPre.setTitle("From top to bottom is sequential, From left to right is concurrent");
		preHeader.add(helpPre);
		prePsPanel.setHeader(preHeader);
		
		HorizontalPanel postHeader = new HorizontalPanel();
		postHeader.add(postPsPanel.getHeader());
		Image helpPost = new Image("images/help-hint.png");
		helpPost.addStyleName(css.helpIcon());
		helpPost.setTitle("From top to bottom is sequential, From left to right is concurrent");
		postHeader.add(helpPost);
		postPsPanel.setHeader(postHeader);
		
		
		HorizontalPanel removeHeader = new HorizontalPanel();
		removeHeader.add(removePsPanel.getHeader());
		Image helpRemove = new Image("images/help-hint.png");
		helpRemove.addStyleName(css.helpIcon());
		helpRemove.setTitle("From top to bottom is sequential, From left to right is concurrent");
		removeHeader.add(helpRemove);
		removePsPanel.setHeader(removeHeader);
		
		
		
		generalPanel.add(miscContent);
		initPanel.add(initContent);
		

		VerticalPanel syncContent = new VerticalPanel();
		
		releasePanel.add(releaseContent);
		syncContent.add(releasePanel);
		
		
		ftpCfgPanel.add(ftpContent);
		httpCfgPanel.add(httpContent);
		VerticalPanel downloadChildren = new VerticalPanel();
		downloadChildren.add(downloadContent);
		downloadChildren.add(ftpCfgPanel);
		downloadChildren.add(httpCfgPanel);
		downloadPanel.add(downloadChildren);
		syncContent.add(downloadPanel);
		
		extractPanel.add(extractContent);
		syncContent.add(extractPanel);
		
		makeReleasePanel.add(makeReleaseContent);
		syncContent.add(makeReleasePanel);
		syncPanel.add(syncContent);
		
		dbPanel.add(dbContent);
		
		prePsPanel.add(preProcessEditor);
		postPsPanel.add(postProcessEditor);
		removePsPanel.add(removeProcessEditor);
		
		deploymentPanel.add(deploymentContent);
		
		centerPanel.add(pnlIncludeWarning);
		centerPanel.add(initPanel);
		centerPanel.add(syncPanel);
		centerPanel.add(prePsPanel);
		centerPanel.add(postPsPanel);
		centerPanel.add(removePsPanel);
		centerPanel.add(deploymentPanel);
		centerPanel.add(dbPanel);
		centerPanel.add(generalPanel);
		
		/*
		 * Buttons
		 */
		Command cmdOverride = new Command() {
			
			@Override
			public void execute() {
				
				if (validate()) {
					if (selectedBank.equals("global.properties")) {
						save(null, false);
					} else {
						String dbName = ((TextBox) validator.getWidget(selectedBank, "init__db.name")).getText();
						if (validator.getMode().equals(BankValidator.NEW) || type.equals("included") ||
								!(dbName + ".properties").equals(selectedBank)) {
							showSaveDialog(dbName, false);
						} else {
							save(null, false);
						}
					}
				}
			}
		};
		Command cmdSaveAs = new Command() {
			
			@Override
			public void execute() {
				if (currentIncludedFiles != null && validate()) {
					if (selectedBank.equals("global.properties")) {
						SC.warn("Operation not allowed for 'global.properties'");
					} else {
						String dbName = "";
						if (!type.equals("included"))
							dbName = ((TextBox) validator.getWidget(selectedBank, "init__db.name")).getText();
						showSaveDialog(dbName, false);
					}
				}
			}
		};
		Command cmdSaveAndRun = new Command() {
			
			@Override
			public void execute() {
				if (validate()) {
					
					if (selectedBank.equals("global.properties") || type.equals("included")) {
						SC.warn("Operation not allowed for 'global.properties'");
					} else {
						String dbName = ((TextBox) validator.getWidget(selectedBank, "init__db.name")).getText();
						if (validator.getMode().equals(BankValidator.NEW) ||
								!(dbName + ".properties").equals(selectedBank)) {
							showSaveDialog(dbName, true);
						} else {
							save(null, true);
						}
					}
				}
			}
		};
		
		menuSave.setVisible(false);
		menuSave.addStyleName(css.buttonMenu());
		MenuBar saveMenu = new MenuBar(true);
		menuSave.addItem("Save", saveMenu);
		saveMenu.addItem("Override", cmdOverride);
		saveMenu.addItem("Save as", cmdSaveAs);
		saveMenu.addItem("Save and run update", cmdSaveAndRun);
		
		MenuBar menuCancel = new MenuBar();
		menuCancel.addStyleName(css.buttonMenu());
		menuCancel.addItem("Cancel", new Command() {
			
			@Override
			public void execute() {
				hide();
			}
		});
		
		bottomPanel.setSpacing(3);
		bottomPanel.add(menuSave);
		bottomPanel.add(menuCancel);
		
		loadLocalBankList();
		
		Label loadBank = new Label("BANK SELECTION");
		loadBank.addStyleName(css.bankEditorTitle());
		Label properties = new Label("Properties");
		properties.addStyleName(css.bankEditorSmallTitle());
		Label options = new Label("Options");
		options.addStyleName(css.bankEditorSmallTitle());
		
		HorizontalPanel hpLoad = new HorizontalPanel();
//		hpLoad.add(new Image("images/go-down-search.png"));
		hpLoad.add(loadBank);
		hpLoad.setCellVerticalAlignment(loadBank, HasVerticalAlignment.ALIGN_BOTTOM);
		
		final HorizontalPanel hpOpt = new HorizontalPanel();
		hpOpt.add(options);
		hpOpt.setCellVerticalAlignment(options, HasVerticalAlignment.ALIGN_BOTTOM);
		
		final HorizontalPanel hpProps = new HorizontalPanel();
		hpProps.add(properties);
		hpProps.setCellVerticalAlignment(properties, HasVerticalAlignment.ALIGN_BOTTOM);
		
		mainPanel.add(hpLoad);
		mainPanel.add(topPanel);
		
		bankPanel.addStyleName(css.bankPanel());
		bankPanel.add(hpOpt);
		bankPanel.add(optionsPanel);
		bankPanel.add(hpProps);
		bankPanel.add(centerPanel);
		
		final Label titleSelect = new Label("SELECTED BANK : ");
		titleSelect.addStyleName(css.bankEditorTitle());
		lblSelectedBank.addStyleName(css.bankEditorTitleValue());
		
		hpSelectedBank.add(titleSelect);
		hpSelectedBank.add(lblSelectedBank);
		mainPanel.add(hpSelectedBank);
		mainPanel.add(bankPanel);
		
		mainPanel.add(bottomPanel);
		mainPanel.setCellHorizontalAlignment(bottomPanel, HasAlignment.ALIGN_CENTER);
		
		bankPanel.setVisible(false);
		hpSelectedBank.setVisible(false);
		
		/*
		 * Building top panel
		 */
		remoteBankList.setVisible(false);
		
		Image refreshList = new Image("images/view-refresh-4.png");
		refreshList.addStyleName(css.imgPointer());
		refreshList.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				loadLocalBankList();
			}
		});
		radioLoadLocal.setValue(true);
		
		
		final HorizontalPanel hpLocal = new HorizontalPanel();
		hpLocal.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		hpLocal.add(radioLoadLocal);
		hpLocal.add(localBankList);
		hpLocal.add(refreshList);
		localBankList.setWidth("200px");
		hpLocal.setCellWidth(radioLoadLocal, "150px");
		
		final HorizontalPanel hpRemote = new HorizontalPanel();
		hpRemote.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		final TextBox tbUrl = new TextBox();
		tbUrl.setWidth("200px");
		Image goBtn = new Image("images/edit-find-5.png");
		goBtn.addStyleName(css.imgPointer());
		goBtn.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				if (!tbUrl.getText().trim().isEmpty())
					loadRemoteBankList(tbUrl.getText());
			}
		});
		hpRemote.add(radioLoadRemote);
		hpRemote.add(tbUrl);
		hpRemote.add(goBtn);
		hpRemote.add(remoteBankList);
		hpRemote.setCellWidth(radioLoadRemote, "150px");
		
		final HorizontalPanel hpEmpty = new HorizontalPanel();
		hpEmpty.addStyleName(css.subCbPanel());
		hpEmpty.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		Label lblTemplate = new Label("Select template : ");
		lblTemplate.setWidth("150px");
		hpEmpty.add(lblTemplate);
		hpEmpty.add(templateList);
		hpEmpty.add(lblTemplateDesc);
		lblTemplateDesc.setHTML(BmajWatcherConstants.INSTANCE.mandatoryDescription());
		templateList.setWidth("200px");
		templateList.addItem("Mandatory");
		templateList.addItem("Common");
		templateList.addItem("Exhaustive");
		templateList.addChangeHandler(new ChangeHandler() {
			
			@Override
			public void onChange(ChangeEvent event) {
				String value = templateList.getItemText(templateList.getSelectedIndex());
				if (value.equals("Mandatory"))
					lblTemplateDesc.setHTML(BmajWatcherConstants.INSTANCE.mandatoryDescription());
				else if (value.equals("Common"))
					lblTemplateDesc.setHTML(BmajWatcherConstants.INSTANCE.commonDescription());
				else if (value.equals("Exhaustive"))
					lblTemplateDesc.setHTML(BmajWatcherConstants.INSTANCE.exhaustiveDescription());
			}
		});
		hpEmpty.setCellWidth(radioEmptyBank, "250px");
		
		hpLocal.setHeight("25px");
		hpRemote.setHeight("25px");
		hpEmpty.setHeight("25px");
		
		
		RadioButton rbEditBank = new RadioButton("neworedit", "Edit bank");
		rbEditBank.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				hpEmpty.setVisible(false);
				hpLocal.setVisible(true);
				hpRemote.setVisible(true);
			}
		});
		final RadioButton rbNewBank = new RadioButton("neworedit", "Create new bank");
		rbNewBank.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				hpEmpty.setVisible(true);
				hpLocal.setVisible(false);
				hpRemote.setVisible(false);
			}
		});
		rbEditBank.setValue(true);
		
		Button load = new Button("Load", new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				String value = "";
				if (rbNewBank.getValue()) {
					type = "empty";
					value = templateList.getValue(templateList.getSelectedIndex());
				} else if (radioLoadLocal.getValue()) {
					type = "local";
					value = localBankList.getValue(localBankList.getSelectedIndex());
				} else if (radioLoadRemote.getValue()) {
					type = "remote";
					if (remoteBankList.getItemCount() > 0) {
						value = remoteBankList.getValue(remoteBankList.getSelectedIndex());
					} else
						value = "";
				}
				
				hpIncludeList.setVisible(type.equals("local"));
				
				if (!value.isEmpty()) {
					bankPanel.setVisible(true);
					hpSelectedBank.setVisible(true);
					menuSave.setVisible(true);
					
					addInclude.setEnabled(type.equals("local"));
					getProperties(value);
				}
			}
		});
		
		VerticalPanel vpEdit = new VerticalPanel();
		vpEdit.addStyleName(css.subCbPanel());
		vpEdit.add(hpLocal);
		vpEdit.add(hpRemote);
		Label lblSelectBank = new Label("You can choose to either create a new bank or edit an existing bank's properties :");
		lblSelectBank.addStyleName(css.selectBankLabel());
		topPanel.add(lblSelectBank);
		topPanel.add(rbEditBank);
		topPanel.add(vpEdit);
		topPanel.add(rbNewBank);
		topPanel.add(hpEmpty);
		topPanel.add(load);
		
		hpEmpty.setVisible(false);
		
		topPanel.setCellHorizontalAlignment(load, HasHorizontalAlignment.ALIGN_CENTER);
		/*
		 * END topPanel
		 */
		
		add(mainPanel);
	}
	
	private void loadChangedFile() {
		String value = parentList.getItemText(parentList.getSelectedIndex());
		
		if (currentIncludedFiles.get(currentFile) != null) { // If include file was not removed
			Map<String, String> pre = preProcessEditor.getProcessProperties();
			Map<String, String> post = postProcessEditor.getProcessProperties();
			Map<String, String> remove = removeProcessEditor.getProcessProperties();
			
			Map<String, String> ps = new HashMap<String, String>();
			ps.putAll(pre);
			ps.putAll(post);
			ps.putAll(remove);
			validator.setBankProcesses(currentFile, ps);
			
			BankValidator.clearProcesses(currentIncludedFiles.get(currentFile));
			currentIncludedFiles.get(currentFile).putAll(ps);
		}
		
		pnlIncludeWarning.setVisible(false);
		if (value.equals("global.properties")) {
			pnlIncludeWarning.setVisible(true);
			lblIncludeWarning.setText(BmajWatcherConstants.INSTANCE.globalWarning());
		} else if (!value.equals(selectedBank)) { // another include file
			pnlIncludeWarning.setVisible(true);
			lblIncludeWarning.setText(BmajWatcherConstants.INSTANCE.includeWarning());
		}
		
		currentFile = value;
		boolean enable = currentFile.equals(selectedBank);
		seeInherited.setEnabled(enable);
		override.setEnabled(enable);
		removeInclude.setEnabled(!value.equals(selectedBank) && !value.equals("global.properties"));
		
		populateProperties(currentIncludedFiles.get(value));
	}
	
	private boolean validate() {
		if (currentIncludedFiles != null) {
			Map<String, String> ps = new HashMap<String, String>();
			
			ps.putAll(preProcessEditor.getProcessProperties());
			ps.putAll(postProcessEditor.getProcessProperties());
			ps.putAll(removeProcessEditor.getProcessProperties());
			validator.setBankProcesses(currentFile, ps);

			boolean looseValidation = selectedBank.equals("global.properties");
			return validator.validateValues(currentIncludedFiles, looseValidation);
		}
		return false;
	}
	
	private void save(final Map<String, String> newBankNames, boolean runUpdate) {
		
		Map<String, Map<String, String>> res = validator.getNewBankProperties();
		if (res != null) {
			/*
			 * Add include.properties property
			 */
			StringBuilder sb = new StringBuilder();
			for (String inc : currentIncludedFiles.keySet()) {
				if (!inc.equals(selectedBank) && !inc.equals("global.properties") && res.containsKey(inc)) {
					sb.append(sb.length() == 0 ? inc : "," + inc);
				}
			}
			if (sb.length() > 0)
				res.get(selectedBank).put("misc__include.properties", sb.toString());
			else {
				res.get(selectedBank).put("misc__include.properties", "__deleted");
			}
			
			if (newBankNames != null) {
				/*
				 * Add renamed include.properties for included files
				 */
				String includedProperties = "";
				for (String oldBank : newBankNames.keySet()) {
					if (!oldBank.equals("global.properties") && !oldBank.equals(selectedBank)) {
						includedProperties += newBankNames.get(oldBank) + ",";
					}
				}
				if (includedProperties.length() > 0) {
					res.get(selectedBank).put("misc__include.properties", includedProperties.substring(0, includedProperties.length() - 1));
				}
			}
			
			final int total = res.size();
			pos = 0;
			for (String bankName : res.keySet()) {
				
				final String newName = newBankNames != null && newBankNames.get(bankName) != null ?
						newBankNames.get(bankName).substring(0, newBankNames.get(bankName).lastIndexOf('.')) :
							bankName.substring(0, bankName.lastIndexOf('.'));
				
				server.save(type, bankName.substring(0, bankName.lastIndexOf('.')),
						newName, res.get(bankName), runUpdate && bankName.equals(selectedBank), new AsyncCallback<Void>() {
					
					@Override
					public void onSuccess(Void result) {
						if (++pos == total) {
							final String nn = newBankNames != null ?
									newBankNames.get(selectedBank).substring(0, newBankNames.get(selectedBank).lastIndexOf('.')) :
										selectedBank.substring(0, selectedBank.lastIndexOf('.'));
							
							/*
							 * Update bank list and reload the bank
							 */
							server.getBankList(new AsyncCallback<Collection<String>>() {
								
								@Override
								public void onSuccess(Collection<String> result) {
									localBankList.clear();
									int index = 0;
									for (String s : result) {
										if (s.equals(nn))
											index = localBankList.getItemCount();
										localBankList.addItem(s);
									}
									
									localBankList.setSelectedIndex(index);
									radioLoadLocal.setValue(true);
									type = "local";
									getProperties(nn);
								}
								
								@Override
								public void onFailure(Throwable caught) {
									SC.say("Failure !");
								}
							});
						}
					}
					
					@Override
					public void onFailure(Throwable caught) {
						SC.say("Failure");
					}
				});
			}
		}
	}
	
	private void showSaveDialog(String dbName, final boolean runUpdate) {
		final DialogBox dbSave = new DialogBox(false, true);
		dbSave.addStyleName(css.bankEditor());
		dbSave.setWidth("320px");
		dbSave.setHTML("<b>Save as...</b>");
		VerticalPanel vp = new VerticalPanel();
		vp.setSpacing(5);
		
		HorizontalPanel warningPnl = new HorizontalPanel();
		warningPnl.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		warningPnl.setSpacing(3);
		warningPnl.addStyleName(css.warningPanel());
		Image warningImg = new Image("images/vcs-conflicting.png");
		Label warningLbl = new Label("Note that BioMAJ needs the file name to be the same as db.name property. If these are different the bank won't be updated.", true);
		warningPnl.add(warningImg);
		warningPnl.add(warningLbl);
		vp.add(warningPnl);
		
		final Map<TextBox, String> boxes = new HashMap<TextBox, String>();
		for (String fileName : currentIncludedFiles.keySet()) {
			if (!fileName.equals("global.properties")) {
				TextBox tb = new TextBox();
				tb.setWidth("350px");
				if (fileName.equals(selectedBank))
					tb.setText(dbName + ".properties");
				else
					tb.setText(fileName);
				vp.add(tb);
				boxes.put(tb, fileName);
			}
		}
		HorizontalPanel hpBtn = new HorizontalPanel();
		Button ok = new Button("Save", new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				Map<String, String> newBankNames = new HashMap<String, String>();
				boolean valid = true;
				for (TextBox tb : boxes.keySet()) {
					if (tb.getText().trim().isEmpty() || tb.getText().equals(".properties")) {
						tb.addStyleName(css.bankEditorErrorWidget());
						valid = false;
						break;
					} else {
						tb.removeStyleName(css.bankEditorErrorWidget());
						newBankNames.put(boxes.get(tb), tb.getText());
					}
				}
				if (valid) {
					save(newBankNames, runUpdate);
					dbSave.hide();
				}
			}
		});
		Button cancel = new Button("Cancel", new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				dbSave.hide();
			}
		});
		hpBtn.add(ok);
		hpBtn.add(cancel);
		vp.add(hpBtn);
		vp.setCellHorizontalAlignment(hpBtn, HasHorizontalAlignment.ALIGN_CENTER);
		dbSave.setWidget(vp);
		dbSave.center();
	}
	
	private void loadLocalBankList() {
		server.getBankList(new AsyncCallback<Collection<String>>() {
			
			@Override
			public void onSuccess(Collection<String> result) {
				localBankList.clear();
				for (String s : result)
					localBankList.addItem(s);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.say("Failure !");
			}
		});
	}
	
	private void loadRemoteBankList(String url) {
		server.getRemoteBankList(url, new AsyncCallback<Collection<String>>() {
			
			@Override
			public void onSuccess(Collection<String> result) {
				remoteBankList.setVisible(true);
				for (String s : result) {
					remoteBankList.addItem(s);
				}
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.say("Failure !");
			}
		});
	}
	
	private void getProperties(final String bankName) {
		override.setEnabled(true);
		seeInherited.setEnabled(true);
		removeInclude.setEnabled(false);
		
		pnlIncludeWarning.setVisible(false);
		
		if (type.equals("empty")) {
			lblSelectedBank.setText("New bank");
			server.getEmptyBank(bankName, new AsyncCallback<Map<String, Map<String,String>>>() {
				
				@Override
				public void onSuccess(Map<String, Map<String, String>> result) {
					parentList.clear();
					parentList.addItem(bankName + ".properties");
					parentList.addItem("global.properties");
					selectedBank = bankName + ".properties";
					currentFile = bankName + ".properties";
					currentIncludedFiles = result;
					validator.clear(selectedBank, BankValidator.NEW);
					populateProperties(result.get(currentFile));
				}
				
				@Override
				public void onFailure(Throwable caught) {
					SC.say("Failure !");
				}	
			});
		} else {
			lblSelectedBank.setText(bankName);
			loadBank(bankName, new ArrayList<String>());
		}
	}
	
	private void loadBank(final String bankName, final Collection<String> includedProps) {
		
		/*
		 * Load includable files
		 */
		server.getIncludePropertiesList(new AsyncCallback<Collection<String>>() {
			
			@Override
			public void onSuccess(Collection<String> result) {
				includeList.clear();
				includeList.addItem(CREATE_NEW_INCLUDE);
				for (String s : result)
					includeList.addItem(s);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.warn("Could not retrieve included properties");
			}
		});
		
		server.getBankProperties(bankName, type, includedProps, new AsyncCallback<Map<String, String>>() {
			
			@Override
			public void onSuccess(final Map<String, String> mainResult) {
				if (mainResult != null) {
					parentList.clear();
					
					server.getIncludedProperties(bankName, includedProps, new AsyncCallback<Map<String,Map<String,String>>>() {
						
						@Override
						public void onSuccess(Map<String, Map<String, String>> result) {
							if (result != null) {
								parentList.addItem(bankName + ".properties");
								for (String key : result.keySet()) {
									parentList.addItem(key);
									if (!key.equals("global.properties")) {
										removeItemFromList(key.substring(key.lastIndexOf('/') + 1), includeList);
									}
								}
								currentFile = bankName + ".properties";
								selectedBank = bankName + ".properties";
								currentIncludedFiles = result;
								currentIncludedFiles.put(currentFile, mainResult);
								if (type.equals("local"))
									validator.clear(selectedBank, BankValidator.MODIFY);
								else
									validator.clear(selectedBank, BankValidator.NEW);
								populateProperties(mainResult);
							} else {
								SC.warn("Load failure ! Please check the bank properties");
							}
						}
						
						@Override
						public void onFailure(Throwable caught) {
							SC.say("Failure !");
						}
					});
				}
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.say("Failure !");
			}
		});
	}
	
	private static void removeItemFromList(String toRemove, ListBox list) {
		for (int i = 0; i < list.getItemCount(); i++) {
			if (list.getItemText(i).equals(toRemove)) {
				list.removeItem(i);
				break;
			}
		}
	}
	
	private void addProperty(String key) {
		server.getPrefixedKey(key, new AsyncCallback<String>() {
			
			@Override
			public void onSuccess(String result) {
				currentIncludedFiles.get(currentFile).put(result, "");
				String inheritedProp = "inherited:" + result;
				// If a parent file is selected, add to descendants
				if (currentFile.equals("global.properties")) {
					for (String bank : currentIncludedFiles.keySet()) {
						if (!bank.equals("global.properties"))
							currentIncludedFiles.get(bank).put(inheritedProp, "");
					}
				} else if (!currentFile.equals(selectedBank)) {
					currentIncludedFiles.get(selectedBank).put(inheritedProp, "");
				}
				buildPropertyLine(result, "", null);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.warn("Could not retrieve prefixed key !");
			}
		});
	}
	
	private void buildPropertyLine(final String key, String propValue, Map<String, String> processContent) {
		
		final String[] split = key.split("__");
		String type = "";
		boolean inherited = false;
		if (split[0].contains(":")) { 
			type = split[0].split(":")[1];
			inherited = true;
		} else
			type = split[0];
		
		boolean isBinary = false;
		boolean isList = false;
		String[] elts = {};
		if (type.contains(">")) {
			if ((elts = getPropertyElement(type)) == null)
				isBinary = true;
			else
				isList = true;
			
			type = type.split(">")[0];
		}
		
		if (type.equals("misc") && processContent != null) {
			processContent.put(split[1], propValue);
			return;
		}
		
		if (inherited && seeInherited.getValue() || !inherited) {
			
			stockProps.remove(split[1]);
			HorizontalPanel hp = new HorizontalPanel();
			hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			Label label = new Label(split[1]);
			label.setWidth("200px");
			
			PushButton btnRemove = new PushButton(new Image("images/edit-delete.png"));
			btnRemove.addStyleName(css.removePropertyButton());
			hp.add(btnRemove);
			if (!selectedBank.equals("global.properties") && validator.getMandatoryProps().contains(split[1]) && !inherited && !BankValidator.propertyExistsInOtherFile(key, currentFile, currentIncludedFiles)) {
				btnRemove.setEnabled(false);
			} else {
				btnRemove.addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
//						if (!validator.removeValue(currentFile, key, currentIncludedFiles)) {
						validator.removeValue(currentFile, key, currentIncludedFiles);
						int i;
						for (i = 0; i < propertyListBox.getItemCount(); i++) {
							if (propertyListBox.getItemText(i).compareTo(split[1]) > 0) {
								propertyListBox.insertItem(split[1], i);
								break;
							}
						}
						if (i == propertyListBox.getItemCount())
							propertyListBox.insertItem(split[1], i);
//						}
					}
				});
			}
			hp.add(label);
			
			FocusWidget w = validator.getWidget(currentFile, key);
			if (w != null) {
				hp.add(w);
				w.setEnabled(override.getValue() && inherited || !inherited);
			} else {
				if (isBinary) {
					CheckBox cb = new CheckBox();
					cb.setEnabled(override.getValue() && inherited || !inherited);
					hp.add(cb);
					cb.setValue(Boolean.valueOf(propValue));
					validator.addValue(currentFile, key, cb);
				} else if (isList) {
					ListBox lb = new ListBox(false);
					int index = 0;
					for (int i = 0; i < elts.length; i++) {
						if (elts[i].equals(propValue))
							index = i;
						lb.addItem(elts[i]);
						
					}
					lb.setEnabled(override.getValue() && inherited || !inherited);
					lb.setSelectedIndex(index);
					hp.add(lb);
					validator.addValue(currentFile, key, lb);
				} else {				
					TextBox value = new TextBox();
					validator.addValue(currentFile, key, value);
					value.addStyleName(css.bankEditorTextBox());
					value.setEnabled(override.getValue() && inherited || !inherited);
					value.setText(propValue);
					hp.add(value);
				}
			}
			
			if (inherited && !override.getValue())
				validator.updateInheritedProperty(key, currentFile);
			
			Image help = new Image("images/help-about.png");
			if (this.propertyHelp != null)
				help.setTitle(this.propertyHelp.get(split[1]));
			help.addStyleName(css.helpIcon());
			hp.add(help);
			
			if (type.equals("general")) {
				generalPanel.setVisible(true);
				miscContent.add(hp);
			} else if (type.equals("init")) {
				initPanel.setVisible(true);
				initContent.add(hp);
			} else if (type.equals("ftpconfig")) {
				ftpCfgPanel.setVisible(true);
				ftpContent.add(hp);
			} else if (type.equals("httpconfig")) {
				httpCfgPanel.setVisible(true);
				httpContent.add(hp);
			} else if (type.equals("db")) {
				dbContent.add(hp);
			} else if (type.equals("release")) {
				releasePanel.setVisible(true);
				releaseContent.add(hp);
			} else if (type.equals("download")) {
				downloadPanel.setVisible(true);
				downloadContent.add(hp);
			} else if (type.equals("extract")) {
				extractPanel.setVisible(true);
				extractContent.add(hp);
			} else if (type.equals("makerelease")) {
				makeReleasePanel.setVisible(true);
				makeReleaseContent.add(hp);
			} else if (type.equals("deployment")) {
				deploymentPanel.setVisible(true);
				deploymentContent.add(hp);
			}
		}
	}
	
	private void populateProperties(Map<String, String> map) {
		
		miscContent.clear();
		initContent.clear();
		releaseContent.clear();
		downloadContent.clear();
		extractContent.clear();
		makeReleaseContent.clear();
		dbContent.clear();
		ftpContent.clear();
		httpContent.clear();
		deploymentContent.clear();

		generalPanel.setVisible(false);
		initPanel.setVisible(false);
		ftpCfgPanel.setVisible(false);
		httpCfgPanel.setVisible(false);
		downloadPanel.setVisible(false);
		extractPanel.setVisible(false);
		deploymentPanel.setVisible(false);
		makeReleasePanel.setVisible(false);
		releasePanel.setVisible(false);
		dbPanel.setVisible(currentFile.equals("global.properties"));
		
		Map<String, String> processContent = new HashMap<String, String>();
		validator.setRefValues(currentFile, map);
		
		propertyListBox.setEnabled(true);
		
		// Rebuild of property list
		stockProps.clear();
		for (String key : propertyHelp.keySet()) {
			stockProps.add(key);
		}
		
		// Populate properties
		for (final String key : map.keySet()) { // inherited:type>list|el1,el2_prop
			buildPropertyLine(key, map.get(key), processContent);
		}
		
		// Add property inherited from parents
//		for (String key : currentIncludedFiles.keySet()) {
//			if (!key.equals(currentFile)) {
//				for (String key2 : currentIncludedFiles.get(key).keySet()) {
//					stockProps.remove(key2.split("__")[1]);
//				}
//			}
//		}
		
		/*
		parent = httpContent;
		while (!((parent = parent.getParent()) instanceof DisclosurePanel));
		parent.setVisible(httpContent.getWidgetCount() != 0);
		
		parent = ftpContent;
		while (!((parent = parent.getParent()) instanceof DisclosurePanel));
		parent.setVisible(ftpContent.getWidgetCount() != 0);
		*/
		
		propertyListBox.clear();
		for (String propName : stockProps) {
			if (propName.startsWith("database.") && currentFile.equals("global.properties"))
				propertyListBox.addItem(propName);
			else if (!propName.startsWith("database."))
				propertyListBox.addItem(propName);
		}
		
		preProcessEditor.load(processContent, ProcessEditor.PRE);
		postProcessEditor.load(processContent, ProcessEditor.POST);
		removeProcessEditor.load(processContent, ProcessEditor.REMOVE);
	}
	
	/**
	 * Returns a list of elements or null if the string represents
	 * a binary field.
	 * 
	 * @param s
	 * @return
	 */
	private String[] getPropertyElement(String s) {
		//inherited:type>list|el1,el2_prop
		
		String[] split = s.split(">");
		if (split[1].equals("bin"))
			return null;
		else {
			return split[1].split("\\|")[1].split(",");
		}
	}
	
	/**
	 * Displays the dialog with the given bank loaded.
	 * 
	 * @param bank
	 */
	public void show(final String bank) {
		
		/*
		 * Refreshes bank list
		 */
		server.getBankList(new AsyncCallback<Collection<String>>() {
			
			@Override
			public void onSuccess(Collection<String> result) {
				localBankList.clear();
				int index = -1;
				int i = 0;
				for (String s : result) {
					localBankList.addItem(s);
					if (index < 0 && s.equals(bank))
						index = i;
					i++;
				}
				
				if (index < 0) { // Bank not found
					SC.warn("Can't load bank. '" + bank + ".properties' does not exist.");
				} else {
					localBankList.setSelectedIndex(index);
					hpSelectedBank.setVisible(true);
					bankPanel.setVisible(true);
					menuSave.setVisible(true);
					
					type = "local";
					getProperties(bank);
					show();
				}
				
			}
			
			@Override
			public void onFailure(Throwable caught) {
				SC.say("Failure !");
			}
		});
	}
	
	public static BankEditorDialog getInstance() {
		return instance;
	}
}
