package org.inria.bmajwatcher.client.services;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * Service that handles scheduling stuff.
 * 
 * @author rsabas
 *
 */
@RemoteServiceRelativePath("schedulingService")
public interface SchedulingService extends RemoteService{

	/**
	 * Creates a trigger with a given name and a schedule represented
	 * by a cron expression.
	 * 
	 * @param label
	 * @param cron 
	 * 
	 * @return true if successful
	 */
	public boolean createTrigger(String label, String cron);
	
	/**
	 * Deletes the trigger with the corresponding label and all
	 * the corresponding jobs.
	 * 
	 * @param label
	 */
	public void deleteTrigger(String label);
	
	/**
	 * Renames the <code>oldName</code> trigger with the <code>newName</code>.
	 * 
	 * @param oldName
	 * @param newName
	 */
	public void renameTrigger(String oldName, String newName);
	
	/**
	 * Sets the cron expression of the trigger represented by <code>name</code>
	 * to <code>cron</code>.
	 * 
	 * @param name
	 * @param cron
	 * 
	 * @return true if successful
	 */
	public boolean setCron(String name, String cron);
	
	/**
	 * Adds a bank to the given trigger.
	 * 
	 * @param bankName
	 * @param triggerName
	 */
	public void addBanksToTrigger(String bankName[], String triggerName);
	
	/**
	 * Removes a bank list from the given trigger.
	 * 
	 * @param bankNames
	 * @param triggerName
	 */
	public void removeBanksFromTrigger(String[] bankNames, String triggerName);
	
	/**
	 * Returns the job list.
	 * 
	 * @return
	 */
	public Map<String, List<String>> getJobs();
	
	/**
	 * Returns a list of dates within the specified range together
	 * with the job it is related to.
	 * 
	 * @param current
	 * @param range
	 * @return
	 */
	public Map<Date, String> getJobsDates(Date current, int range);
	
}
