package org.inria.bmajwatcher.client.services;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("bankStatService")
public interface BankStatService extends RemoteService {
	
	/**
	 * Returns global statistics about the banks managed by biomaj.
	 * - number of online banks
	 * - number of error banks
	 * - number of updating banks
	 * 
	 * @return
	 */
	public Map<String, Integer> banksStatus();
	
	/**
	 * Returns a list of objects that contain information about a given
	 * bank across its updates.
	 * 
	 * @param bankName
	 * @return
	 */
	public List<Map<String, String>> getBankStats(String bankName);
	
	/**
	 * Returns info about all the online banks.
	 * These are :
	 * 	- size of the bank
	 * 	- name of the bank
	 * 	- server from where the bank was downloaded
	 * 	- type of the bank
	 * @return
	 */
	public List<Map<String, String>> getBanksInfo();
}
