package org.inria.bmajwatcher.client.services;

import java.util.Collection;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface BankEditingServiceAsync {
	
	public static final BankEditingServiceAsync INSTANCE = GWT.create(BankEditingService.class);

	void getBankProperties(String bankName, String type, Collection<String> included, AsyncCallback<Map<String, String>> callback);

	void getBankList(AsyncCallback<Collection<String>> callback);

	void getIncludedProperties(String bankName, Collection<String> included,
			AsyncCallback<Map<String, Map<String, String>>> callback);

	void getRemoteBankList(String url, AsyncCallback<Collection<String>> callback);

	void save(String type, String bankName, String newName, Map<String, String> newProps, boolean runUpdate,
			AsyncCallback<Void> callback);

	void getEmptyBank(String pattern,
			AsyncCallback<Map<String,  Map<String, String>>> callback);

	void getPropertyHelp(AsyncCallback<Map<String, String>> callback);

	void getMandatoryProperties(AsyncCallback<Collection<String>> callback);

	void getPrefixedKey(String key, AsyncCallback<String> callback);

	void getIncludePropertiesList(AsyncCallback<Collection<String>> callback);

	void getProcessList(AsyncCallback<Collection<String>> callback);

	void getProcessDescription(String process, AsyncCallback<String> callback);

	void propertiesFileExists(String fileName, AsyncCallback<Boolean> callback);
}
