package org.inria.bmajwatcher.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * Authentication service.
 * 
 * @author rsabas
 *
 */
@RemoteServiceRelativePath("authenticationService")
public interface AuthenticationService extends RemoteService {
	
	/**
	 * Authentication method that takes user login and password and
	 * returns wether authentication failed or succeed.
	 *  
	 * @param login
	 * @param passwd
	 * @return
	 */
	public boolean authenticate(String login, String passwd);
	
	/**
	 * Supposed to return user group or null if no user is logged.
	 * As we only have admin and guest mode, whe return a random string
	 * if admin is logged and null if not.
	 * 
	 * @return
	 */
	public String getUserAcces();
	
	/**
	 * Removes user from session.
	 */
	public void logout();
}
