import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.Matcher;


/**
 * Class that initializes the required properties for
 * BioMAJWatcher to work.
 * 
 * @author osallou
 *
 */
public class WatcherConfigurator {
	
	
	private static String biomajConf = "";

        private static String biomajRoot = "";
  
        private static final String MESSAGE_MAX ="30";
	
	
	public static void main(String[] args) {

		
		Map<String, String> params = new HashMap<String, String>();
		
		for (String arg : args) {
			String[] pair = arg.split(":=");
			if (pair.length > 1)
				params.put(pair[0], pair[1]);
			else
				params.put(pair[0], "");
		}

		biomajConf = params.get("bmajconf");
                biomajRoot = params.get("bmajroot");
		
		/*
		 * Context.xml
		 */
		System.out.println("Updating Context.xml...");
		try {
			PrintWriter pw = new PrintWriter(biomajConf + "/BmajWatcher.xml");
			
			pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			pw.println("<Context path=\"/BmajWatcher\" docBase=\"/usr/share/java/webapps/biomaj-watcher\"  reloadable=\"false\">");

			pw.println("<!-- ENV VARIABLES -->");
			pw.println("<Parameter name=\"BIOMAJ_ROOT\" value=\"" + biomajRoot + "\" override=\"false\"/>");
			
			pw.println("<!-- WEB INTERFACE CONF -->");
			pw.println("<Parameter name=\"MESSAGE_MAX\" value=\"" + MESSAGE_MAX + "\" override=\"false\"/>");

			pw.println("<Parameter name=\"USELOCAL\" value=\"1\" override=\"false\"/>");
			pw.println("<!-- LDAP CONF -->");
			if (params.get("use_ldap").equals("true"))
				pw.println("<Parameter name=\"USELDAP\" value=\"1\" override=\"false\"/>");
			else
				pw.println("<Parameter name=\"USELDAP\" value=\"0\" override=\"false\"/>");

			createPasswdFile(params.get("app_login"), params.get("app_passwd"));
			
			pw.println("<Parameter name=\"LDAPHOST\" value=\"" + params.get("ldap_host") + "\" override=\"false\"/>");
			pw.println("<Parameter name=\"LDAPDN\" value=\"" + params.get("ldap_dn") + "\" override=\"false\"/>");
			pw.println("<Parameter name=\"OPTFILTER\" value=\"" + params.get("opt_filter") + "\" override=\"false\"/>");
			
			pw.println("<!-- LOCAL/REMOTE EXECUTION -->");
			pw.println("<Parameter name=\"EXECUTION\" value=\"local\" override=\"false\"/>");

			pw.println("<!-- SSH CONFIG -->");
			pw.println("<Parameter name=\"SSH_AUTH_TYPE\" value=\"\" override=\"false\"/>");
			pw.println("<Parameter name=\"SSH_LOGIN\" value=\"\" override=\"false\"/>");
			pw.println("<Parameter name=\"SSH_PASSWD\" value=\"\" override=\"false\"/>");
			pw.println("<Parameter name=\"SSH_KEY_PATH\" value=\"\" override=\"false\"/>");
			pw.println("<Parameter name=\"SSH_PASSPHRASE\" value=\"\" override=\"false\"/>");
			pw.println("<Parameter name=\"SSH_HOSTS\" value=\"\" override=\"false\"/>");
			
			
			pw.println("</Context>");
			
			pw.close();
			
                        String logBase = "/var/log/biomaj";

			pw = new PrintWriter(biomajConf + "/BmajWatcher#logs.xml");
			
			pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			pw.println("<Context docBase=\"" + logBase + "\" debug=\"0\" privileged=\"true\">");
			pw.println("</Context>");
			
			pw.close();
		} catch (FileNotFoundException e) {
			System.err.println(e.toString());
		}

		System.out.println("Configuration complete");
	}
	
	private static void createPasswdFile(String login, String passwd) {
		try {
			PrintWriter pw = new PrintWriter(biomajRoot + "/.bmajwatcherpasswd");
			MessageDigest digest = MessageDigest.getInstance("SHA1");
			digest.update(login.getBytes());
			byte[] hashedLogin = digest.digest();

			digest.reset();
			digest.update(passwd.getBytes());
			byte[] hashedPasswd = digest.digest();
			
			pw.println(getHexString(hashedLogin) + ":" + getHexString(hashedPasswd));
			pw.close();
		} catch (FileNotFoundException e) {
			System.err.println(e.toString());
		} catch (NoSuchAlgorithmException e) {
			System.err.println(e.toString());
		}
	}
	
	public static String getHexString(byte[] buf) {
		char[] TAB_BYTE_HEX = { '0', '1', '2', '3', '4', '5', '6', '7', '8',
				'9', 'a', 'b', 'c', 'd', 'e', 'f' };

		StringBuilder sb = new StringBuilder(buf.length * 2);

		for (int i = 0; i < buf.length; i++) {
			sb.append(TAB_BYTE_HEX[(buf[i] >>> 4) & 0xf]);
			sb.append(TAB_BYTE_HEX[buf[i] & 0x0f]);
		}
		return sb.toString();
	}
	
}

