/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.ByteValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.FloatValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.IntValueCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.ReturnCommand;
import com.google.gwt.rpc.client.ast.RpcCommand;
import com.google.gwt.rpc.client.ast.RpcCommandVisitor;
import com.google.gwt.rpc.client.ast.SetCommand;
import com.google.gwt.rpc.client.ast.ShortValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ThrowCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.client.impl.EscapeUtil;
import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SimplePayloadSink
extends CommandSink {
    static final boolean PRETTY = false;
    public static final char ARRAY_TYPE = '[';
    public static final char BACKREF_TYPE = '@';
    public static final char BOOLEAN_TYPE = 'Z';
    public static final char BYTE_TYPE = 'B';
    public static final char CHAR_TYPE = 'C';
    public static final char DOUBLE_TYPE = 'D';
    public static final char ENUM_TYPE = 'E';
    public static final char FLOAT_TYPE = 'F';
    public static final char INT_TYPE = 'I';
    public static final char INVOKE_TYPE = '!';
    public static final char LONG_TYPE = 'J';
    public static final char NL_CHAR = '\n';
    public static final char OBJECT_TYPE = 'L';
    public static final char RETURN_TYPE = 'R';
    public static final char RPC_SEPARATOR_CHAR = '~';
    public static final char SHORT_TYPE = 'S';
    public static final char STRING_TYPE = '\"';
    public static final char THROW_TYPE = 'T';
    public static final char VOID_TYPE = 'V';
    private final Map<ValueCommand, Integer> backRefs = new HashMap<ValueCommand, Integer>();
    private final Appendable buffer;

    public SimplePayloadSink(Appendable buffer) {
        this.buffer = buffer;
    }

    public void accept(RpcCommand command) throws SerializationException {
        new Visitor().accept(command);
    }

    public void finish() throws SerializationException {
    }

    private class Visitor
    extends RpcCommandVisitor {
        private Visitor() {
        }

        public void endVisit(BooleanValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('Z', x.getValue() != false ? "1" : "0");
        }

        public void endVisit(ByteValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('B', x.getValue().toString());
        }

        public void endVisit(CharValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('C', String.valueOf((int)x.getValue().charValue()));
        }

        public void endVisit(DoubleValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('D', x.getValue().toString());
        }

        public void endVisit(EnumValueCommand x, RpcCommandVisitor.Context ctx) {
            if (this.appendIdentity(x)) {
                this.appendTypedData('E', x.getValue().getDeclaringClass().getName());
                this.appendTypedData('I', String.valueOf(x.getValue().ordinal()));
            }
        }

        public void endVisit(FloatValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('F', x.getValue().toString());
        }

        public void endVisit(IntValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('I', x.getValue().toString());
        }

        public void endVisit(LongValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('J', x.getValue().toString());
        }

        public void endVisit(NullValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('V', "");
        }

        public void endVisit(ShortValueCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('S', x.getValue().toString());
        }

        public void endVisit(StringValueCommand x, RpcCommandVisitor.Context ctx) {
            if (this.appendIdentity(x)) {
                String value = x.getValue();
                this.appendTypedData('\"', String.valueOf(value.length()));
                this.append(value);
            }
        }

        public boolean visit(ArrayValueCommand x, RpcCommandVisitor.Context ctx) {
            if (this.appendIdentity(x)) {
                int dims = 1;
                Class<?> leaf = x.getComponentType();
                while (leaf.getComponentType() != null) {
                    ++dims;
                    leaf = leaf.getComponentType();
                }
                this.appendTypedData('[', leaf.getName());
                this.accept(new IntValueCommand(dims));
                this.accept(new IntValueCommand(x.getComponentValues().size()));
                return true;
            }
            return false;
        }

        public boolean visit(InstantiateCommand x, RpcCommandVisitor.Context ctx) {
            if (this.appendIdentity(x)) {
                this.appendTypedData('L', x.getTargetClass().getName());
                this.accept(new IntValueCommand(x.getSetters().size()));
                return true;
            }
            return false;
        }

        public boolean visit(InvokeCustomFieldSerializerCommand x, RpcCommandVisitor.Context ctx) {
            if (this.appendIdentity(x)) {
                this.appendTypedData('!', x.getTargetClass().getName());
                this.accept(new IntValueCommand(x.getValues().size()));
                this.accept(x.getValues());
                this.accept(new IntValueCommand(x.getSetters().size()));
                this.accept(x.getSetters());
                return false;
            }
            return false;
        }

        public boolean visit(ReturnCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('R', String.valueOf(x.getValues().size()));
            return true;
        }

        public boolean visit(SetCommand x, RpcCommandVisitor.Context ctx) {
            if (!GWT.isScript()) {
                this.accept(new StringValueCommand(x.getFieldDeclClass().getName()));
            }
            this.accept(new StringValueCommand(x.getField()));
            return true;
        }

        public boolean visit(ThrowCommand x, RpcCommandVisitor.Context ctx) {
            this.appendTypedData('T', "");
            return true;
        }

        private void append(String x) {
            try {
                SimplePayloadSink.this.buffer.append(EscapeUtil.escape(x)).append('~');
            }
            catch (IOException e) {
                this.halt(e);
            }
        }

        private boolean appendIdentity(ValueCommand x) {
            Integer backRef = (Integer)SimplePayloadSink.this.backRefs.get(x);
            if (backRef != null) {
                this.append('@' + String.valueOf(backRef));
                return false;
            }
            SimplePayloadSink.this.backRefs.put(x, SimplePayloadSink.this.backRefs.size());
            return true;
        }

        private void appendTypedData(char type, String value) {
            try {
                SimplePayloadSink.this.buffer.append(type).append(value).append('~');
            }
            catch (IOException e) {
                this.halt(e);
            }
        }
    }
}

