
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/userblacklist/kamailio-userblacklist.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#include "db_userblacklist.h"

/* database variables */
/* TODO assign read-write or read-only URI, introduce a parameter in XML */

//extern str userblacklist_db_url;
db1_con_t * userblacklist_dbh = NULL;
db_func_t userblacklist_dbf;

str userblacklist_table = str_init("userblacklist");

/* column names */
str userblacklist_id_col = str_init("id");
str userblacklist_username_col = str_init("username");
str userblacklist_domain_col = str_init("domain");
str userblacklist_prefix_col = str_init("prefix");
str userblacklist_whitelist_col = str_init("whitelist");

/* table version */
const unsigned int userblacklist_version = 1;

str globalblacklist_table = str_init("globalblacklist");

/* column names */
str globalblacklist_id_col = str_init("id");
str globalblacklist_prefix_col = str_init("prefix");
str globalblacklist_whitelist_col = str_init("whitelist");
str globalblacklist_description_col = str_init("description");

/* table version */
const unsigned int globalblacklist_version = 1;


/*
 * Closes the DB connection.
 */
void userblacklist_db_close(void) {
	if (userblacklist_dbh) {
		userblacklist_dbf.close(userblacklist_dbh);
		userblacklist_dbh = NULL;
	}
}


/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int userblacklist_db_init(void) {
	if (!userblacklist_db_url.s || !userblacklist_db_url.len) {
		LM_ERR("you have to set the db_url module parameter.\n");
		return -1;
	}
	if (db_bind_mod(&userblacklist_db_url, &userblacklist_dbf) < 0) {
		LM_ERR("can't bind database module.\n");
		return -1;
	}
	if ((userblacklist_dbh = userblacklist_dbf.init(&userblacklist_db_url)) == NULL) {
		LM_ERR("can't connect to database.\n");
		return -1;
	}
	if (
	(db_check_table_version(&userblacklist_dbf, userblacklist_dbh, &userblacklist_table, userblacklist_version) < 0) ||
	(db_check_table_version(&userblacklist_dbf, userblacklist_dbh, &globalblacklist_table, globalblacklist_version) < 0)
	) {
		LM_ERR("during table version check.\n");
		userblacklist_db_close();
		return -1;
	}
	userblacklist_db_close();
	return 0;
}


/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occured.
 */
int userblacklist_db_open(void) {
	if (userblacklist_dbh) {
		userblacklist_dbf.close(userblacklist_dbh);
	}
	if ((userblacklist_dbh = userblacklist_dbf.init(&userblacklist_db_url)) == NULL) {
		LM_ERR("can't connect to database.\n");
		return -1;
	}
	return 0;
}

