// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateMesh = "CreateMesh"

// CreateMeshRequest generates a "aws/request.Request" representing the
// client's request for the CreateMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMesh for more information on using the CreateMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMeshRequest method.
//    req, resp := client.CreateMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateMesh
func (c *AppMesh) CreateMeshRequest(input *CreateMeshInput) (req *request.Request, output *CreateMeshOutput) {
	op := &request.Operation{
		Name:       opCreateMesh,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes",
	}

	if input == nil {
		input = &CreateMeshInput{}
	}

	output = &CreateMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMesh API operation for AWS App Mesh.
//
// Creates a new service mesh. A service mesh is a logical boundary for network
// traffic between the services that reside within it.
//
// After you create your service mesh, you can create virtual nodes, virtual
// routers, and routes to distribute traffic between the applications in your
// mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateMesh
func (c *AppMesh) CreateMesh(input *CreateMeshInput) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	return out, req.Send()
}

// CreateMeshWithContext is the same as CreateMesh with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateMeshWithContext(ctx aws.Context, input *CreateMeshInput, opts ...request.Option) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateRoute
func (c *AppMesh) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for AWS App Mesh.
//
// Creates a new route that is associated with a virtual router.
//
// You can use the prefix parameter in your route specification for path-based
// routing of requests. For example, if your virtual router service name is
// my-service.local, and you want the route to match requests to my-service.local/metrics,
// then your prefix should be /metrics.
//
// If your route matches a request, you can distribute traffic to one or more
// target virtual nodes with relative weighting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateRoute
func (c *AppMesh) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualNode = "CreateVirtualNode"

// CreateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualNode for more information on using the CreateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVirtualNodeRequest method.
//    req, resp := client.CreateVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateVirtualNode
func (c *AppMesh) CreateVirtualNodeRequest(input *CreateVirtualNodeInput) (req *request.Request, output *CreateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualNodes",
	}

	if input == nil {
		input = &CreateVirtualNodeInput{}
	}

	output = &CreateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualNode API operation for AWS App Mesh.
//
// Creates a new virtual node within a service mesh.
//
// A virtual node acts as logical pointer to a particular task group, such as
// an Amazon ECS service or a Kubernetes deployment. When you create a virtual
// node, you must specify the DNS service discovery name for your task group.
//
// Any inbound traffic that your virtual node expects should be specified as
// a listener. Any outbound traffic that your virtual node expects to reach
// should be specified as a backend.
//
// The response metadata for your new virtual node contains the arn that is
// associated with the virtual node. Set this value (either the full ARN or
// the truncated resource name, for example, mesh/default/virtualNode/simpleapp,
// as the APPMESH_VIRTUAL_NODE_NAME environment variable for your task group's
// Envoy proxy container in your task definition or pod spec. This is then mapped
// to the node.id and node.cluster Envoy parameters.
//
// If you require your Envoy stats or tracing to use a different name, you can
// override the node.cluster value that is set by APPMESH_VIRTUAL_NODE_NAME
// with the APPMESH_VIRTUAL_NODE_CLUSTER environment variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateVirtualNode
func (c *AppMesh) CreateVirtualNode(input *CreateVirtualNodeInput) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	return out, req.Send()
}

// CreateVirtualNodeWithContext is the same as CreateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualNodeWithContext(ctx aws.Context, input *CreateVirtualNodeInput, opts ...request.Option) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualRouter = "CreateVirtualRouter"

// CreateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualRouter for more information on using the CreateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVirtualRouterRequest method.
//    req, resp := client.CreateVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouterRequest(input *CreateVirtualRouterInput) (req *request.Request, output *CreateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualRouters",
	}

	if input == nil {
		input = &CreateVirtualRouterInput{}
	}

	output = &CreateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualRouter API operation for AWS App Mesh.
//
// Creates a new virtual router within a service mesh.
//
// Virtual routers handle traffic for one or more service names within your
// mesh. After you create your virtual router, create and associate routes for
// your virtual router that direct incoming requests to different virtual nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouter(input *CreateVirtualRouterInput) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	return out, req.Send()
}

// CreateVirtualRouterWithContext is the same as CreateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualRouterWithContext(ctx aws.Context, input *CreateVirtualRouterInput, opts ...request.Option) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMesh = "DeleteMesh"

// DeleteMeshRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMesh for more information on using the DeleteMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMeshRequest method.
//    req, resp := client.DeleteMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteMesh
func (c *AppMesh) DeleteMeshRequest(input *DeleteMeshInput) (req *request.Request, output *DeleteMeshOutput) {
	op := &request.Operation{
		Name:       opDeleteMesh,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meshes/{meshName}",
	}

	if input == nil {
		input = &DeleteMeshInput{}
	}

	output = &DeleteMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMesh API operation for AWS App Mesh.
//
// Deletes an existing service mesh.
//
// You must delete all resources (routes, virtual routers, virtual nodes) in
// the service mesh before you can delete the mesh itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You cannot delete the specified resource because it is in use or required
//   by another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteMesh
func (c *AppMesh) DeleteMesh(input *DeleteMeshInput) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	return out, req.Send()
}

// DeleteMeshWithContext is the same as DeleteMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteMeshWithContext(ctx aws.Context, input *DeleteMeshInput, opts ...request.Option) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteRoute
func (c *AppMesh) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoute API operation for AWS App Mesh.
//
// Deletes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You cannot delete the specified resource because it is in use or required
//   by another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteRoute
func (c *AppMesh) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualNode = "DeleteVirtualNode"

// DeleteVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualNode for more information on using the DeleteVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualNodeRequest method.
//    req, resp := client.DeleteVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNodeRequest(input *DeleteVirtualNodeInput) (req *request.Request, output *DeleteVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualNode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DeleteVirtualNodeInput{}
	}

	output = &DeleteVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualNode API operation for AWS App Mesh.
//
// Deletes an existing virtual node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You cannot delete the specified resource because it is in use or required
//   by another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNode(input *DeleteVirtualNodeInput) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	return out, req.Send()
}

// DeleteVirtualNodeWithContext is the same as DeleteVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualNodeWithContext(ctx aws.Context, input *DeleteVirtualNodeInput, opts ...request.Option) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualRouter = "DeleteVirtualRouter"

// DeleteVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualRouter for more information on using the DeleteVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualRouterRequest method.
//    req, resp := client.DeleteVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouterRequest(input *DeleteVirtualRouterInput) (req *request.Request, output *DeleteVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualRouter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DeleteVirtualRouterInput{}
	}

	output = &DeleteVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualRouter API operation for AWS App Mesh.
//
// Deletes an existing virtual router.
//
// You must delete any routes associated with the virtual router before you
// can delete the router itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You cannot delete the specified resource because it is in use or required
//   by another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouter(input *DeleteVirtualRouterInput) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	return out, req.Send()
}

// DeleteVirtualRouterWithContext is the same as DeleteVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualRouterWithContext(ctx aws.Context, input *DeleteVirtualRouterInput, opts ...request.Option) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMesh = "DescribeMesh"

// DescribeMeshRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMesh for more information on using the DescribeMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMeshRequest method.
//    req, resp := client.DescribeMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeMesh
func (c *AppMesh) DescribeMeshRequest(input *DescribeMeshInput) (req *request.Request, output *DescribeMeshOutput) {
	op := &request.Operation{
		Name:       opDescribeMesh,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}",
	}

	if input == nil {
		input = &DescribeMeshInput{}
	}

	output = &DescribeMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMesh API operation for AWS App Mesh.
//
// Describes an existing service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeMesh
func (c *AppMesh) DescribeMesh(input *DescribeMeshInput) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	return out, req.Send()
}

// DescribeMeshWithContext is the same as DescribeMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeMeshWithContext(ctx aws.Context, input *DescribeMeshInput, opts ...request.Option) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoute = "DescribeRoute"

// DescribeRouteRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoute for more information on using the DescribeRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRouteRequest method.
//    req, resp := client.DescribeRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeRoute
func (c *AppMesh) DescribeRouteRequest(input *DescribeRouteInput) (req *request.Request, output *DescribeRouteOutput) {
	op := &request.Operation{
		Name:       opDescribeRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DescribeRouteInput{}
	}

	output = &DescribeRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoute API operation for AWS App Mesh.
//
// Describes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeRoute
func (c *AppMesh) DescribeRoute(input *DescribeRouteInput) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	return out, req.Send()
}

// DescribeRouteWithContext is the same as DescribeRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeRouteWithContext(ctx aws.Context, input *DescribeRouteInput, opts ...request.Option) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualNode = "DescribeVirtualNode"

// DescribeVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualNode for more information on using the DescribeVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualNodeRequest method.
//    req, resp := client.DescribeVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNodeRequest(input *DescribeVirtualNodeInput) (req *request.Request, output *DescribeVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualNode,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DescribeVirtualNodeInput{}
	}

	output = &DescribeVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualNode API operation for AWS App Mesh.
//
// Describes an existing virtual node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNode(input *DescribeVirtualNodeInput) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	return out, req.Send()
}

// DescribeVirtualNodeWithContext is the same as DescribeVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualNodeWithContext(ctx aws.Context, input *DescribeVirtualNodeInput, opts ...request.Option) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualRouter = "DescribeVirtualRouter"

// DescribeVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualRouter for more information on using the DescribeVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualRouterRequest method.
//    req, resp := client.DescribeVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouterRequest(input *DescribeVirtualRouterInput) (req *request.Request, output *DescribeVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualRouter,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DescribeVirtualRouterInput{}
	}

	output = &DescribeVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualRouter API operation for AWS App Mesh.
//
// Describes an existing virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouter(input *DescribeVirtualRouterInput) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	return out, req.Send()
}

// DescribeVirtualRouterWithContext is the same as DescribeVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualRouterWithContext(ctx aws.Context, input *DescribeVirtualRouterInput, opts ...request.Option) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMeshes = "ListMeshes"

// ListMeshesRequest generates a "aws/request.Request" representing the
// client's request for the ListMeshes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeshes for more information on using the ListMeshes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMeshesRequest method.
//    req, resp := client.ListMeshesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListMeshes
func (c *AppMesh) ListMeshesRequest(input *ListMeshesInput) (req *request.Request, output *ListMeshesOutput) {
	op := &request.Operation{
		Name:       opListMeshes,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeshesInput{}
	}

	output = &ListMeshesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeshes API operation for AWS App Mesh.
//
// Returns a list of existing service meshes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListMeshes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListMeshes
func (c *AppMesh) ListMeshes(input *ListMeshesInput) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	return out, req.Send()
}

// ListMeshesWithContext is the same as ListMeshes with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeshes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesWithContext(ctx aws.Context, input *ListMeshesInput, opts ...request.Option) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeshesPages iterates over the pages of a ListMeshes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeshes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMeshes operation.
//    pageNum := 0
//    err := client.ListMeshesPages(params,
//        func(page *ListMeshesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListMeshesPages(input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool) error {
	return c.ListMeshesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeshesPagesWithContext same as ListMeshesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesPagesWithContext(ctx aws.Context, input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeshesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeshesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMeshesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRoutes = "ListRoutes"

// ListRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutes for more information on using the ListRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutesRequest method.
//    req, resp := client.ListRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListRoutes
func (c *AppMesh) ListRoutesRequest(input *ListRoutesInput) (req *request.Request, output *ListRoutesOutput) {
	op := &request.Operation{
		Name:       opListRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutesInput{}
	}

	output = &ListRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutes API operation for AWS App Mesh.
//
// Returns a list of existing routes in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListRoutes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListRoutes
func (c *AppMesh) ListRoutes(input *ListRoutesInput) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	return out, req.Send()
}

// ListRoutesWithContext is the same as ListRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesWithContext(ctx aws.Context, input *ListRoutesInput, opts ...request.Option) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutesPages iterates over the pages of a ListRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoutes operation.
//    pageNum := 0
//    err := client.ListRoutesPages(params,
//        func(page *ListRoutesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListRoutesPages(input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool) error {
	return c.ListRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutesPagesWithContext same as ListRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesPagesWithContext(ctx aws.Context, input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRoutesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVirtualNodes = "ListVirtualNodes"

// ListVirtualNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualNodes for more information on using the ListVirtualNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVirtualNodesRequest method.
//    req, resp := client.ListVirtualNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListVirtualNodes
func (c *AppMesh) ListVirtualNodesRequest(input *ListVirtualNodesInput) (req *request.Request, output *ListVirtualNodesOutput) {
	op := &request.Operation{
		Name:       opListVirtualNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualNodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualNodesInput{}
	}

	output = &ListVirtualNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualNodes API operation for AWS App Mesh.
//
// Returns a list of existing virtual nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualNodes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListVirtualNodes
func (c *AppMesh) ListVirtualNodes(input *ListVirtualNodesInput) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	return out, req.Send()
}

// ListVirtualNodesWithContext is the same as ListVirtualNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesWithContext(ctx aws.Context, input *ListVirtualNodesInput, opts ...request.Option) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualNodesPages iterates over the pages of a ListVirtualNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualNodes operation.
//    pageNum := 0
//    err := client.ListVirtualNodesPages(params,
//        func(page *ListVirtualNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListVirtualNodesPages(input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool) error {
	return c.ListVirtualNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualNodesPagesWithContext same as ListVirtualNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesPagesWithContext(ctx aws.Context, input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVirtualNodesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVirtualRouters = "ListVirtualRouters"

// ListVirtualRoutersRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualRouters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualRouters for more information on using the ListVirtualRouters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVirtualRoutersRequest method.
//    req, resp := client.ListVirtualRoutersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListVirtualRouters
func (c *AppMesh) ListVirtualRoutersRequest(input *ListVirtualRoutersInput) (req *request.Request, output *ListVirtualRoutersOutput) {
	op := &request.Operation{
		Name:       opListVirtualRouters,
		HTTPMethod: "GET",
		HTTPPath:   "/meshes/{meshName}/virtualRouters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualRoutersInput{}
	}

	output = &ListVirtualRoutersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualRouters API operation for AWS App Mesh.
//
// Returns a list of existing virtual routers in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualRouters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/ListVirtualRouters
func (c *AppMesh) ListVirtualRouters(input *ListVirtualRoutersInput) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	return out, req.Send()
}

// ListVirtualRoutersWithContext is the same as ListVirtualRouters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualRouters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersWithContext(ctx aws.Context, input *ListVirtualRoutersInput, opts ...request.Option) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualRoutersPages iterates over the pages of a ListVirtualRouters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualRouters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualRouters operation.
//    pageNum := 0
//    err := client.ListVirtualRoutersPages(params,
//        func(page *ListVirtualRoutersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListVirtualRoutersPages(input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool) error {
	return c.ListVirtualRoutersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualRoutersPagesWithContext same as ListVirtualRoutersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersPagesWithContext(ctx aws.Context, input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualRoutersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualRoutersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVirtualRoutersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opUpdateRoute = "UpdateRoute"

// UpdateRouteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoute for more information on using the UpdateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRouteRequest method.
//    req, resp := client.UpdateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateRoute
func (c *AppMesh) UpdateRouteRequest(input *UpdateRouteInput) (req *request.Request, output *UpdateRouteOutput) {
	op := &request.Operation{
		Name:       opUpdateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &UpdateRouteInput{}
	}

	output = &UpdateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoute API operation for AWS App Mesh.
//
// Updates an existing route for a specified service mesh and virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateRoute
func (c *AppMesh) UpdateRoute(input *UpdateRouteInput) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	return out, req.Send()
}

// UpdateRouteWithContext is the same as UpdateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateRouteWithContext(ctx aws.Context, input *UpdateRouteInput, opts ...request.Option) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualNode = "UpdateVirtualNode"

// UpdateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualNode for more information on using the UpdateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualNodeRequest method.
//    req, resp := client.UpdateVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNodeRequest(input *UpdateVirtualNodeInput) (req *request.Request, output *UpdateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &UpdateVirtualNodeInput{}
	}

	output = &UpdateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualNode API operation for AWS App Mesh.
//
// Updates an existing virtual node in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNode(input *UpdateVirtualNodeInput) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	return out, req.Send()
}

// UpdateVirtualNodeWithContext is the same as UpdateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualNodeWithContext(ctx aws.Context, input *UpdateVirtualNodeInput, opts ...request.Option) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualRouter = "UpdateVirtualRouter"

// UpdateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualRouter for more information on using the UpdateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualRouterRequest method.
//    req, resp := client.UpdateVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouterRequest(input *UpdateVirtualRouterInput) (req *request.Request, output *UpdateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &UpdateVirtualRouterInput{}
	}

	output = &UpdateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualRouter API operation for AWS App Mesh.
//
// Updates an existing virtual router in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You do not have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource does not exist. Check your request syntax and try
//   again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2018-10-01/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouter(input *UpdateVirtualRouterInput) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	return out, req.Send()
}

// UpdateVirtualRouterWithContext is the same as UpdateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualRouterWithContext(ctx aws.Context, input *UpdateVirtualRouterInput, opts ...request.Option) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateMeshInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name to use for the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMeshInput) SetClientToken(v string) *CreateMeshInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateMeshInput) SetMeshName(v string) *CreateMeshInput {
	s.MeshName = &v
	return s
}

type CreateMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh following the create call.
	Mesh *MeshData `locationName:"mesh" type:"structure"`
}

// String returns the string representation
func (s CreateMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *CreateMeshOutput) SetMesh(v *MeshData) *CreateMeshOutput {
	s.Mesh = v
	return s
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which to create the route.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name to use for the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The route specification to apply.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router in which to create the route.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRouteInput) SetClientToken(v string) *CreateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateRouteInput) SetMeshName(v string) *CreateRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *CreateRouteInput) SetRouteName(v string) *CreateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateRouteInput) SetSpec(v *RouteSpec) *CreateRouteInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateRouteInput) SetVirtualRouterName(v string) *CreateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your mesh following the create call.
	Route *RouteData `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *CreateRouteOutput) SetRoute(v *RouteData) *CreateRouteOutput {
	s.Route = v
	return s
}

type CreateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which to create the virtual node.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The virtual node specification to apply.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The name to use for the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualNodeInput) SetClientToken(v string) *CreateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualNodeInput) SetMeshName(v string) *CreateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *CreateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *CreateVirtualNodeInput) SetVirtualNodeName(v string) *CreateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type CreateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node following the create call.
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure"`
}

// String returns the string representation
func (s CreateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *CreateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *CreateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type CreateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which to create the virtual router.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The virtual router specification to apply.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The name to use for the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualRouterInput) SetClientToken(v string) *CreateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualRouterInput) SetMeshName(v string) *CreateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *CreateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateVirtualRouterInput) SetVirtualRouterName(v string) *CreateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type CreateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router following the create call.
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s CreateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *CreateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *CreateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DeleteMeshInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteMeshInput) SetMeshName(v string) *DeleteMeshInput {
	s.MeshName = &v
	return s
}

type DeleteMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The service mesh that was deleted.
	Mesh *MeshData `locationName:"mesh" type:"structure"`
}

// String returns the string representation
func (s DeleteMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DeleteMeshOutput) SetMesh(v *MeshData) *DeleteMeshOutput {
	s.Mesh = v
	return s
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which to delete the route.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to delete.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router in which to delete the route.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteRouteInput) SetMeshName(v string) *DeleteRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DeleteRouteInput) SetRouteName(v string) *DeleteRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteRouteInput) SetVirtualRouterName(v string) *DeleteRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The route that was deleted.
	Route *RouteData `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DeleteRouteOutput) SetRoute(v *RouteData) *DeleteRouteOutput {
	s.Route = v
	return s
}

type DeleteVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which to delete the virtual node.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node to delete.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualNodeInput) SetMeshName(v string) *DeleteVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DeleteVirtualNodeInput) SetVirtualNodeName(v string) *DeleteVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DeleteVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The virtual node that was deleted.
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DeleteVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DeleteVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DeleteVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which to delete the virtual router.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to delete.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualRouterInput) SetMeshName(v string) *DeleteVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteVirtualRouterInput) SetVirtualRouterName(v string) *DeleteVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The virtual router that was deleted.
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DeleteVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DeleteVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DescribeMeshInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to describe.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeMeshInput) SetMeshName(v string) *DescribeMeshInput {
	s.MeshName = &v
	return s
}

type DescribeMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh.
	Mesh *MeshData `locationName:"mesh" type:"structure"`
}

// String returns the string representation
func (s DescribeMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DescribeMeshOutput) SetMesh(v *MeshData) *DescribeMeshOutput {
	s.Mesh = v
	return s
}

type DescribeRouteInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the route resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to describe.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router with which the route is associated.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeRouteInput) SetMeshName(v string) *DescribeRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DescribeRouteInput) SetRouteName(v string) *DescribeRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeRouteInput) SetVirtualRouterName(v string) *DescribeRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your route.
	Route *RouteData `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s DescribeRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DescribeRouteOutput) SetRoute(v *RouteData) *DescribeRouteOutput {
	s.Route = v
	return s
}

type DescribeVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the virtual node resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node to describe.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualNodeInput) SetMeshName(v string) *DescribeVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DescribeVirtualNodeInput) SetVirtualNodeName(v string) *DescribeVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DescribeVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node.
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DescribeVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DescribeVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DescribeVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the virtual router resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to describe.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualRouterInput) SetMeshName(v string) *DescribeVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeVirtualRouterInput) SetVirtualRouterName(v string) *DescribeVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router.
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DescribeVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DescribeVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

// The DNS service discovery information for your virtual node.
type DnsServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// The DNS service name for your virtual node.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s DnsServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsServiceDiscovery) GoString() string {
	return s.String()
}

// SetServiceName sets the ServiceName field's value.
func (s *DnsServiceDiscovery) SetServiceName(v string) *DnsServiceDiscovery {
	s.ServiceName = &v
	return s
}

// An object representing the health check policy for a virtual node's listener.
type HealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// The number of consecutive successful health checks that must occur before
	// declaring listener healthy.
	//
	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// The time period in milliseconds between each health check execution.
	//
	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	// The destination path for the health check request. This is only required
	// if the specified protocol is HTTP; if the protocol is TCP, then this parameter
	// is ignored.
	Path *string `locationName:"path" type:"string"`

	// The destination port for the health check request. This port must match the
	// port defined in the PortMapping for the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol for the health check request.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"PortProtocol"`

	// The amount of time to wait when receiving a response from the health check,
	// in milliseconds.
	//
	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual node unhealthy.
	//
	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation
func (s HealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckPolicy"}
	if s.HealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThreshold", 2))
	}
	if s.IntervalMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.TimeoutMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutMillis", 2000))
	}
	if s.UnhealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckPolicy) SetHealthyThreshold(v int64) *HealthCheckPolicy {
	s.HealthyThreshold = &v
	return s
}

// SetIntervalMillis sets the IntervalMillis field's value.
func (s *HealthCheckPolicy) SetIntervalMillis(v int64) *HealthCheckPolicy {
	s.IntervalMillis = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HealthCheckPolicy) SetPath(v string) *HealthCheckPolicy {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckPolicy) SetPort(v int64) *HealthCheckPolicy {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckPolicy) SetProtocol(v string) *HealthCheckPolicy {
	s.Protocol = &v
	return s
}

// SetTimeoutMillis sets the TimeoutMillis field's value.
func (s *HealthCheckPolicy) SetTimeoutMillis(v int64) *HealthCheckPolicy {
	s.TimeoutMillis = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckPolicy) SetUnhealthyThreshold(v int64) *HealthCheckPolicy {
	s.UnhealthyThreshold = &v
	return s
}

// An object representing the HTTP routing specification for a route.
type HttpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	Action *HttpRouteAction `locationName:"action" type:"structure"`

	// The criteria for determining an HTTP request match.
	Match *HttpRouteMatch `locationName:"match" type:"structure"`
}

// String returns the string representation
func (s HttpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRoute"}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *HttpRoute) SetAction(v *HttpRouteAction) *HttpRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpRoute) SetMatch(v *HttpRouteMatch) *HttpRoute {
	s.Match = v
	return s
}

// An object representing the traffic distribution requirements for matched
// HTTP requests.
type HttpRouteAction struct {
	_ struct{} `type:"structure"`

	// The targets that traffic is routed to when a request matches the route. You
	// can specify one or more targets and their relative weights with which to
	// distribute traffic.
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" type:"list"`
}

// String returns the string representation
func (s HttpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteAction"}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *HttpRouteAction) SetWeightedTargets(v []*WeightedTarget) *HttpRouteAction {
	s.WeightedTargets = v
	return s
}

// An object representing the requirements for a route to match HTTP requests
// for a virtual router.
type HttpRouteMatch struct {
	_ struct{} `type:"structure"`

	// Specifies the path with which to match requests. This parameter must always
	// start with /, which by itself matches all requests to the virtual router
	// service name. You can also match for path-based routing of requests. For
	// example, if your virtual router service name is my-service.local, and you
	// want the route to match requests to my-service.local/metrics, then your prefix
	// should be /metrics.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s HttpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRouteMatch) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *HttpRouteMatch) SetPrefix(v string) *HttpRouteMatch {
	s.Prefix = &v
	return s
}

type ListMeshesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of mesh results returned by ListMeshes in paginated output.
	// When this parameter is used, ListMeshes only returns limit results in a single
	// page along with a nextToken response element. The remaining results of the
	// initial request can be seen by sending another ListMeshes request with the
	// returned nextToken value. This value can be between 1 and 100. If this parameter
	// is not used, then ListMeshes returns up to 100 results and a nextToken value
	// if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListMeshes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMeshesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeshesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMeshesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMeshesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListMeshesInput) SetLimit(v int64) *ListMeshesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesInput) SetNextToken(v string) *ListMeshesInput {
	s.NextToken = &v
	return s
}

type ListMeshesOutput struct {
	_ struct{} `type:"structure"`

	// The list of existing service meshes.
	//
	// Meshes is a required field
	Meshes []*MeshRef `locationName:"meshes" type:"list" required:"true"`

	// The nextToken value to include in a future ListMeshes request. When the results
	// of a ListMeshes request exceed limit, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMeshesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeshesOutput) GoString() string {
	return s.String()
}

// SetMeshes sets the Meshes field's value.
func (s *ListMeshesOutput) SetMeshes(v []*MeshRef) *ListMeshesOutput {
	s.Meshes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesOutput) SetNextToken(v string) *ListMeshesOutput {
	s.NextToken = &v
	return s
}

type ListRoutesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of mesh results returned by ListRoutes in paginated output.
	// When this parameter is used, ListRoutes only returns limit results in a single
	// page along with a nextToken response element. The remaining results of the
	// initial request can be seen by sending another ListRoutes request with the
	// returned nextToken value. This value can be between 1 and 100. If this parameter
	// is not used, then ListRoutes returns up to 100 results and a nextToken value
	// if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh in which to list routes.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListRoutes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the virtual router in which to list routes.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRoutesInput) SetLimit(v int64) *ListRoutesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListRoutesInput) SetMeshName(v string) *ListRoutesInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesInput) SetNextToken(v string) *ListRoutesInput {
	s.NextToken = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *ListRoutesInput) SetVirtualRouterName(v string) *ListRoutesInput {
	s.VirtualRouterName = &v
	return s
}

type ListRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRoutes request. When the results
	// of a ListRoutes request exceed limit, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing routes for the specified service mesh and virtual router.
	//
	// Routes is a required field
	Routes []*RouteRef `locationName:"routes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesOutput) SetNextToken(v string) *ListRoutesOutput {
	s.NextToken = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *ListRoutesOutput) SetRoutes(v []*RouteRef) *ListRoutesOutput {
	s.Routes = v
	return s
}

type ListVirtualNodesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of mesh results returned by ListVirtualNodes in paginated
	// output. When this parameter is used, ListVirtualNodes only returns limit
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListVirtualNodes
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListVirtualNodes returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh in which to list virtual nodes.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListVirtualNodes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListVirtualNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualNodesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualNodesInput) SetLimit(v int64) *ListVirtualNodesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualNodesInput) SetMeshName(v string) *ListVirtualNodesInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesInput) SetNextToken(v string) *ListVirtualNodesInput {
	s.NextToken = &v
	return s
}

type ListVirtualNodesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualNodes request. When
	// the results of a ListVirtualNodes request exceed limit, this value can be
	// used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual nodes for the specified service mesh.
	//
	// VirtualNodes is a required field
	VirtualNodes []*VirtualNodeRef `locationName:"virtualNodes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesOutput) SetNextToken(v string) *ListVirtualNodesOutput {
	s.NextToken = &v
	return s
}

// SetVirtualNodes sets the VirtualNodes field's value.
func (s *ListVirtualNodesOutput) SetVirtualNodes(v []*VirtualNodeRef) *ListVirtualNodesOutput {
	s.VirtualNodes = v
	return s
}

type ListVirtualRoutersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of mesh results returned by ListVirtualRouters in paginated
	// output. When this parameter is used, ListVirtualRouters only returns limit
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListVirtualRouters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListVirtualRouters returns up to
	// 100 results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh in which to list virtual routers.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListVirtualRouters
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListVirtualRoutersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualRoutersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualRoutersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualRoutersInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualRoutersInput) SetLimit(v int64) *ListVirtualRoutersInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualRoutersInput) SetMeshName(v string) *ListVirtualRoutersInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersInput) SetNextToken(v string) *ListVirtualRoutersInput {
	s.NextToken = &v
	return s
}

type ListVirtualRoutersOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualRouters request. When
	// the results of a ListVirtualRouters request exceed limit, this value can
	// be used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual routers for the specified service mesh.
	//
	// VirtualRouters is a required field
	VirtualRouters []*VirtualRouterRef `locationName:"virtualRouters" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualRoutersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualRoutersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersOutput) SetNextToken(v string) *ListVirtualRoutersOutput {
	s.NextToken = &v
	return s
}

// SetVirtualRouters sets the VirtualRouters field's value.
func (s *ListVirtualRoutersOutput) SetVirtualRouters(v []*VirtualRouterRef) *ListVirtualRoutersOutput {
	s.VirtualRouters = v
	return s
}

// An object representing a listener for a virtual node.
type Listener struct {
	_ struct{} `type:"structure"`

	// The health check information for the listener.
	HealthCheck *HealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// The port mapping information for the listener.
	PortMapping *PortMapping `locationName:"portMapping" type:"structure"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Listener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Listener"}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *Listener) SetHealthCheck(v *HealthCheckPolicy) *Listener {
	s.HealthCheck = v
	return s
}

// SetPortMapping sets the PortMapping field's value.
func (s *Listener) SetPortMapping(v *PortMapping) *Listener {
	s.PortMapping = v
	return s
}

// An object representing a service mesh returned by a describe operation.
type MeshData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the service mesh.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The status of the service mesh.
	Status *MeshStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s MeshData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *MeshData) SetMeshName(v string) *MeshData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *MeshData) SetMetadata(v *ResourceMetadata) *MeshData {
	s.Metadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MeshData) SetStatus(v *MeshStatus) *MeshData {
	s.Status = v
	return s
}

// An object representing a service mesh returned by a list operation.
type MeshRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) of the service mesh.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the service mesh.
	MeshName *string `locationName:"meshName" min:"1" type:"string"`
}

// String returns the string representation
func (s MeshRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MeshRef) SetArn(v string) *MeshRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *MeshRef) SetMeshName(v string) *MeshRef {
	s.MeshName = &v
	return s
}

// An object representing the status of a service mesh.
type MeshStatus struct {
	_ struct{} `type:"structure"`

	// The current mesh status.
	Status *string `locationName:"status" type:"string" enum:"MeshStatusCode"`
}

// String returns the string representation
func (s MeshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *MeshStatus) SetStatus(v string) *MeshStatus {
	s.Status = &v
	return s
}

// An object representing a virtual node listener port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port used for the port mapping.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol used for the port mapping.
	Protocol *string `locationName:"protocol" type:"string" enum:"PortProtocol"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortMapping"}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *PortMapping) SetPort(v int64) *PortMapping {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortMapping) SetProtocol(v string) *PortMapping {
	s.Protocol = &v
	return s
}

// An object representing metadata for a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// After you create a virtual node, set this value (either the full ARN or the
	// truncated resource name, for example, mesh/default/virtualNode/simpleapp,
	// as the APPMESH_VIRTUAL_NODE_NAME environment variable for your task group's
	// Envoy proxy container in your task definition or pod spec. This is then mapped
	// to the node.id and node.cluster Envoy parameters.
	//
	// If you require your Envoy stats or tracing to use a different name, you can
	// override the node.cluster value that is set by APPMESH_VIRTUAL_NODE_NAME
	// with the APPMESH_VIRTUAL_NODE_CLUSTER environment variable.
	Arn *string `locationName:"arn" type:"string"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The unique identifier for the resource.
	Uid *string `locationName:"uid" type:"string"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time they are updated.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceMetadata) SetArn(v string) *ResourceMetadata {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ResourceMetadata) SetCreatedAt(v time.Time) *ResourceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ResourceMetadata) SetLastUpdatedAt(v time.Time) *ResourceMetadata {
	s.LastUpdatedAt = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *ResourceMetadata) SetUid(v string) *ResourceMetadata {
	s.Uid = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceMetadata) SetVersion(v int64) *ResourceMetadata {
	s.Version = &v
	return s
}

// An object representing a route returned by a describe operation.
type RouteData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the route resides.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the route.
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The specifications of the route.
	Spec *RouteSpec `locationName:"spec" type:"structure"`

	// The status of the route.
	Status *RouteStatus `locationName:"status" type:"structure"`

	// The virtual router with which the route is associated.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *RouteData) SetMeshName(v string) *RouteData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *RouteData) SetMetadata(v *ResourceMetadata) *RouteData {
	s.Metadata = v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteData) SetRouteName(v string) *RouteData {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *RouteData) SetSpec(v *RouteSpec) *RouteData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RouteData) SetStatus(v *RouteStatus) *RouteData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteData) SetVirtualRouterName(v string) *RouteData {
	s.VirtualRouterName = &v
	return s
}

// An object representing a route returned by a list operation.
type RouteRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the route.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the service mesh in which the route resides.
	MeshName *string `locationName:"meshName" min:"1" type:"string"`

	// The name of the route.
	RouteName *string `locationName:"routeName" min:"1" type:"string"`

	// The virtual router with which the route is associated.
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string"`
}

// String returns the string representation
func (s RouteRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RouteRef) SetArn(v string) *RouteRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *RouteRef) SetMeshName(v string) *RouteRef {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteRef) SetRouteName(v string) *RouteRef {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteRef) SetVirtualRouterName(v string) *RouteRef {
	s.VirtualRouterName = &v
	return s
}

// An object representing the specification of a route.
type RouteSpec struct {
	_ struct{} `type:"structure"`

	// The HTTP routing information for the route.
	HttpRoute *HttpRoute `locationName:"httpRoute" type:"structure"`
}

// String returns the string representation
func (s RouteSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RouteSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RouteSpec"}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpRoute sets the HttpRoute field's value.
func (s *RouteSpec) SetHttpRoute(v *HttpRoute) *RouteSpec {
	s.HttpRoute = v
	return s
}

// An object representing the current status of a route.
type RouteStatus struct {
	_ struct{} `type:"structure"`

	// The current status for the route.
	Status *string `locationName:"status" type:"string" enum:"RouteStatusCode"`
}

// String returns the string representation
func (s RouteStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RouteStatus) SetStatus(v string) *RouteStatus {
	s.Status = &v
	return s
}

// An object representing the service discovery information for a virtual node.
type ServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS service name for the virtual node.
	Dns *DnsServiceDiscovery `locationName:"dns" type:"structure"`
}

// String returns the string representation
func (s ServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceDiscovery) GoString() string {
	return s.String()
}

// SetDns sets the Dns field's value.
func (s *ServiceDiscovery) SetDns(v *DnsServiceDiscovery) *ServiceDiscovery {
	s.Dns = v
	return s
}

type UpdateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which the route resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to update.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The new route specification to apply. This overwrites the existing data.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router with which the route is associated.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateRouteInput) SetClientToken(v string) *UpdateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateRouteInput) SetMeshName(v string) *UpdateRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *UpdateRouteInput) SetRouteName(v string) *UpdateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateRouteInput) SetSpec(v *RouteSpec) *UpdateRouteInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateRouteInput) SetVirtualRouterName(v string) *UpdateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// A full description of the route that was updated.
	Route *RouteData `locationName:"route" type:"structure"`
}

// String returns the string representation
func (s UpdateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *UpdateRouteOutput) SetRoute(v *RouteData) *UpdateRouteOutput {
	s.Route = v
	return s
}

type UpdateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which the virtual node resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The new virtual node specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual node to update.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualNodeInput) SetClientToken(v string) *UpdateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualNodeInput) SetMeshName(v string) *UpdateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *UpdateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *UpdateVirtualNodeInput) SetVirtualNodeName(v string) *UpdateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type UpdateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// A full description of the virtual node that was updated.
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure"`
}

// String returns the string representation
func (s UpdateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *UpdateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *UpdateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type UpdateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh in which the virtual router resides.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The new virtual router specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router to update.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualRouterInput) SetClientToken(v string) *UpdateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualRouterInput) SetMeshName(v string) *UpdateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *UpdateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateVirtualRouterInput) SetVirtualRouterName(v string) *UpdateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// A full description of the virtual router that was updated.
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s UpdateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *UpdateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *UpdateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

// An object representing a virtual node returned by a describe operation.
type VirtualNodeData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the virtual node resides.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual node.
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure"`

	// The specifications of the virtual node.
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure"`

	// The current status for the virtual node.
	Status *VirtualNodeStatus `locationName:"status" type:"structure"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeData) SetMeshName(v string) *VirtualNodeData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualNodeData) SetMetadata(v *ResourceMetadata) *VirtualNodeData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualNodeData) SetSpec(v *VirtualNodeSpec) *VirtualNodeData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeData) SetStatus(v *VirtualNodeStatus) *VirtualNodeData {
	s.Status = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeData) SetVirtualNodeName(v string) *VirtualNodeData {
	s.VirtualNodeName = &v
	return s
}

// An object representing a virtual node returned by a list operation.
type VirtualNodeRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual node.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the service mesh in which the virtual node resides.
	MeshName *string `locationName:"meshName" min:"1" type:"string"`

	// The name of the virtual node.
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string"`
}

// String returns the string representation
func (s VirtualNodeRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualNodeRef) SetArn(v string) *VirtualNodeRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeRef) SetMeshName(v string) *VirtualNodeRef {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeRef) SetVirtualNodeName(v string) *VirtualNodeRef {
	s.VirtualNodeName = &v
	return s
}

// An object representing the specification of a virtual node.
type VirtualNodeSpec struct {
	_ struct{} `type:"structure"`

	// The backends to which the virtual node is expected to send outbound traffic.
	Backends []*string `locationName:"backends" type:"list"`

	// The listeners from which the virtual node is expected to receive inbound
	// traffic.
	Listeners []*Listener `locationName:"listeners" type:"list"`

	// The service discovery information for the virtual node.
	ServiceDiscovery *ServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation
func (s VirtualNodeSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeSpec"}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackends sets the Backends field's value.
func (s *VirtualNodeSpec) SetBackends(v []*string) *VirtualNodeSpec {
	s.Backends = v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *VirtualNodeSpec) SetListeners(v []*Listener) *VirtualNodeSpec {
	s.Listeners = v
	return s
}

// SetServiceDiscovery sets the ServiceDiscovery field's value.
func (s *VirtualNodeSpec) SetServiceDiscovery(v *ServiceDiscovery) *VirtualNodeSpec {
	s.ServiceDiscovery = v
	return s
}

// An object representing the current status of the virtual node.
type VirtualNodeStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual node.
	Status *string `locationName:"status" type:"string" enum:"VirtualNodeStatusCode"`
}

// String returns the string representation
func (s VirtualNodeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeStatus) SetStatus(v string) *VirtualNodeStatus {
	s.Status = &v
	return s
}

// An object representing a virtual router returned by a describe operation.
type VirtualRouterData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh in which the virtual router resides.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual router.
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure"`

	// The specifications of the virtual router.
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure"`

	// The current status of the virtual router.
	Status *VirtualRouterStatus `locationName:"status" type:"structure"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterData) SetMeshName(v string) *VirtualRouterData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualRouterData) SetMetadata(v *ResourceMetadata) *VirtualRouterData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualRouterData) SetSpec(v *VirtualRouterSpec) *VirtualRouterData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterData) SetStatus(v *VirtualRouterStatus) *VirtualRouterData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterData) SetVirtualRouterName(v string) *VirtualRouterData {
	s.VirtualRouterName = &v
	return s
}

// An object representing a virtual router returned by a list operation.
type VirtualRouterRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual router.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the service mesh in which the virtual router resides.
	MeshName *string `locationName:"meshName" min:"1" type:"string"`

	// The name of the virtual router.
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string"`
}

// String returns the string representation
func (s VirtualRouterRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualRouterRef) SetArn(v string) *VirtualRouterRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterRef) SetMeshName(v string) *VirtualRouterRef {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterRef) SetVirtualRouterName(v string) *VirtualRouterRef {
	s.VirtualRouterName = &v
	return s
}

// An object representing the specification of a virtual router.
type VirtualRouterSpec struct {
	_ struct{} `type:"structure"`

	// The service mesh service names to associate with the virtual router.
	ServiceNames []*string `locationName:"serviceNames" type:"list"`
}

// String returns the string representation
func (s VirtualRouterSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterSpec) GoString() string {
	return s.String()
}

// SetServiceNames sets the ServiceNames field's value.
func (s *VirtualRouterSpec) SetServiceNames(v []*string) *VirtualRouterSpec {
	s.ServiceNames = v
	return s
}

// An object representing the status of a virtual router.
type VirtualRouterStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual router.
	Status *string `locationName:"status" type:"string" enum:"VirtualRouterStatusCode"`
}

// String returns the string representation
func (s VirtualRouterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterStatus) SetStatus(v string) *VirtualRouterStatus {
	s.Status = &v
	return s
}

// An object representing a target and its relative weight. Traffic is distributed
// across targets according to their relative weight. For example, a weighted
// target with a relative weight of 50 receives five times as much traffic as
// one with a relative weight of 10.
type WeightedTarget struct {
	_ struct{} `type:"structure"`

	// The virtual node to associate with the weighted target.
	VirtualNode *string `locationName:"virtualNode" min:"1" type:"string"`

	// The relative weight of the weighted target.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation
func (s WeightedTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeightedTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeightedTarget"}
	if s.VirtualNode != nil && len(*s.VirtualNode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *WeightedTarget) SetVirtualNode(v string) *WeightedTarget {
	s.VirtualNode = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *WeightedTarget) SetWeight(v int64) *WeightedTarget {
	s.Weight = &v
	return s
}

const (
	// MeshStatusCodeActive is a MeshStatusCode enum value
	MeshStatusCodeActive = "ACTIVE"

	// MeshStatusCodeDeleted is a MeshStatusCode enum value
	MeshStatusCodeDeleted = "DELETED"

	// MeshStatusCodeInactive is a MeshStatusCode enum value
	MeshStatusCodeInactive = "INACTIVE"
)

const (
	// PortProtocolHttp is a PortProtocol enum value
	PortProtocolHttp = "http"

	// PortProtocolTcp is a PortProtocol enum value
	PortProtocolTcp = "tcp"
)

const (
	// RouteStatusCodeActive is a RouteStatusCode enum value
	RouteStatusCodeActive = "ACTIVE"

	// RouteStatusCodeDeleted is a RouteStatusCode enum value
	RouteStatusCodeDeleted = "DELETED"

	// RouteStatusCodeInactive is a RouteStatusCode enum value
	RouteStatusCodeInactive = "INACTIVE"
)

const (
	// VirtualNodeStatusCodeActive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeActive = "ACTIVE"

	// VirtualNodeStatusCodeDeleted is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeDeleted = "DELETED"

	// VirtualNodeStatusCodeInactive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeInactive = "INACTIVE"
)

const (
	// VirtualRouterStatusCodeActive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeActive = "ACTIVE"

	// VirtualRouterStatusCodeDeleted is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeDeleted = "DELETED"

	// VirtualRouterStatusCodeInactive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeInactive = "INACTIVE"
)
