// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.physicalweb;

import android.support.test.filters.SmallTest;

import junit.framework.TestCase;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Tests for {@link UrlInfo}.
 */
public class UrlInfoTest extends TestCase {
    private static final String URL = "https://example.com";
    UrlInfo mReferenceUrlInfo = null;
    JSONObject mReferenceJsonObject = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mReferenceUrlInfo = new UrlInfo(URL, 99.5, 42)
                .setHasBeenDisplayed()
                .setDeviceAddress("00:11:22:33:AA:BB");
        // Because we can't print JSON sorted by keys, the order is important here.
        mReferenceJsonObject = new JSONObject("{"
                + "    \"url\": \"" + URL + "\","
                + "    \"distance\": 99.5,"
                + "    \"scan_timestamp\": 42,"
                + "    \"device_address\": \"00:11:22:33:AA:BB\","
                + "    \"has_been_displayed\": true"
                + "}");
    }

    @SmallTest
    public void testJsonSerializeWorks() throws JSONException {
        assertEquals(mReferenceJsonObject.toString(), mReferenceUrlInfo.jsonSerialize().toString());
    }

    @SmallTest
    public void testJsonDeserializeWorks() throws JSONException {
        UrlInfo urlInfo = UrlInfo.jsonDeserialize(mReferenceJsonObject);
        assertEquals(mReferenceUrlInfo.getUrl(), urlInfo.getUrl());
        assertEquals(mReferenceUrlInfo.getDistance(), urlInfo.getDistance());
        assertEquals(mReferenceUrlInfo.getScanTimestamp(), urlInfo.getScanTimestamp());
        assertEquals(mReferenceUrlInfo.getDeviceAddress(), urlInfo.getDeviceAddress());
        assertEquals(mReferenceUrlInfo.hasBeenDisplayed(), urlInfo.hasBeenDisplayed());
    }
}
