/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.File;

public class DocumentURI {
    public static final boolean CASE_BLIND_FILES = new File("a").equals(new File("A"));
    private String displayValue;
    private String normalizedValue;

    public DocumentURI(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.displayValue = uri;
        this.normalizedValue = DocumentURI.normalizeURI(uri);
    }

    public String toString() {
        return this.displayValue;
    }

    public boolean equals(Object obj) {
        return obj instanceof DocumentURI && this.normalizedValue.equals(((DocumentURI)obj).normalizedValue);
    }

    public int hashCode() {
        return this.normalizedValue.hashCode();
    }

    public static String normalizeURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("FILE:")) {
            uri = "file:" + uri.substring(5);
        }
        if (uri.startsWith("file:")) {
            if (uri.startsWith("file:///")) {
                uri = "file:/" + uri.substring(8);
            }
            if (CASE_BLIND_FILES) {
                uri = uri.toLowerCase();
            }
        }
        return uri;
    }
}

