#!/bin/sh
# Copyright (c) 2007-2009 Roy Marples <roy@marples.name>
# All rights reserved. Released under the 2-clause BSD license.

: ${CONSOLE:=/dev/console}
: ${RC_LIBEXECDIR:=/lib/rc}

if [ -e "$RC_LIBEXECDIR"/console/unicode ]; then
	termencoding="%G"
	kmode="-u"
else
	termencoding="(K"
	kmode="-a"
fi

# Try and set a font and as early as we can
if [ -e /etc/runlevels/"$RC_DEFAULTLEVEL"/consolefont \
	 -o -e /etc/runlevels/"$RC_BOOTLEVEL"/consolefont ]; then
	printf "\033%s" "$termencoding" >"$CONSOLE" 2>/dev/null
	if [ -r "$RC_LIBEXECDIR"/console/font -a -x /usr/bin/setfont ]; then
		font="$(cat "$RC_LIBEXECDIR"/console/font)"
		[ -c "$CONSOLE" ] && cons="-C $CONSOLE"
		setfont $cons "$RC_LIBEXECDIR"/console/"$font" 2>/dev/null
	fi
fi

# Try and set a keyboard map as early as possible
if [ -e /etc/runlevels/"$RC_DEFAULTLEVEL"/keymaps \
	 -o -e /etc/runlevels/"$RC_BOOTLEVEL"/keymaps ]; then
	kbd_mode $kmode -C "$CONSOLE" 2>/dev/null
	if [ -r "$RC_LIBEXECDIR"/console/keymap ]; then
		loadkeys -q "$RC_LIBEXECDIR"/console/keymap 2>/dev/null
	fi
fi

# Ensure we exit 0 so the boot continues
exit 0
