/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.tree.ArrayEnumeration;
import com.icl.saxon.tree.ChildEnumeration;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.TextImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return (long)this.sequence << 32;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    public final AxisEnumeration enumerateChildren(NodeTest nodeTest) {
        if (this.children == null) {
            return EmptyEnumeration.getInstance();
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)this.children;
            if (nodeTest.matches(nodeImpl)) {
                return new SingletonEnumeration(nodeImpl);
            }
            return EmptyEnumeration.getInstance();
        }
        if (nodeTest instanceof AnyNodeTest) {
            return new ArrayEnumeration((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, nodeTest);
    }

    public final Node getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final Node getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        return nodeImplArray[nodeImplArray.length - 1];
    }

    public final NodeList getChildNodes() {
        if (this.hasChildNodes()) {
            try {
                return new NodeSetExtent(this.enumerateChildren(AnyNodeTest.getInstance()), (NodeOrderComparer)LocalOrderComparer.getInstance());
            }
            catch (XPathException xPathException) {
                return super.getChildNodes();
            }
        }
        return super.getChildNodes();
    }

    protected final NodeImpl getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        if (n < 0 || n >= nodeImplArray.length) {
            return null;
        }
        return nodeImplArray[n];
    }

    public String getStringValue() {
        StringBuffer stringBuffer = null;
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl instanceof TextImpl) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(nodeImpl.getStringValue());
            }
            nodeImpl = nodeImpl.getNextInDocument(this);
        }
        if (stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString();
    }

    public void copyStringValue(Outputter outputter) throws TransformerException {
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl.getNodeType() == 3) {
                nodeImpl.copyStringValue(outputter);
            }
            nodeImpl = nodeImpl.getNextInDocument(this);
        }
    }

    public void useChildrenArray(NodeImpl[] nodeImplArray) {
        this.children = nodeImplArray;
    }

    public void addChild(NodeImpl nodeImpl, int n) {
        NodeImpl[] nodeImplArray;
        if (this.children == null) {
            nodeImplArray = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            nodeImplArray = new NodeImpl[10];
            nodeImplArray[0] = (NodeImpl)this.children;
        } else {
            nodeImplArray = (NodeImpl[])this.children;
        }
        if (n >= nodeImplArray.length) {
            NodeImpl[] nodeImplArray2 = new NodeImpl[nodeImplArray.length * 2];
            System.arraycopy(nodeImplArray, 0, nodeImplArray2, 0, nodeImplArray.length);
            nodeImplArray = nodeImplArray2;
        }
        nodeImplArray[n] = nodeImpl;
        nodeImpl.parent = this;
        nodeImpl.index = n;
        this.children = nodeImplArray;
    }

    public void removeChild(int n) {
        if (this.children instanceof NodeImpl) {
            this.children = null;
        } else {
            ((NodeImpl[])this.children)[n] = null;
        }
    }

    public void renumberChildren() {
        int n = 0;
        if (this.children == null) {
            return;
        }
        if (this.children instanceof NodeImpl) {
            ((NodeImpl)this.children).parent = this;
            ((NodeImpl)this.children).index = 0;
        } else {
            NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
            int n2 = 0;
            while (n2 < nodeImplArray.length) {
                if (nodeImplArray[n2] != null) {
                    nodeImplArray[n2].parent = this;
                    nodeImplArray[n2].index = n;
                    nodeImplArray[n] = nodeImplArray[n2];
                    ++n;
                }
                ++n2;
            }
            this.compact(n);
        }
    }

    public void dropChildren() {
        NodeImpl nodeImpl = this.getNextInDocument(this);
        while (nodeImpl != null) {
            if (nodeImpl instanceof TextImpl) {
                ((TextImpl)nodeImpl).truncateToStart();
                break;
            }
            nodeImpl = nodeImpl.getNextInDocument(this);
        }
        this.children = null;
    }

    public void compact(int n) {
        if (n == 0) {
            this.children = null;
        } else if (n == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] nodeImplArray = new NodeImpl[n];
            System.arraycopy(this.children, 0, nodeImplArray, 0, n);
            this.children = nodeImplArray;
        }
    }

    public String getNodeValue() {
        return null;
    }
}

