/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.httpclient.Cookie;

public class GetCookies
extends DefaultStep {
    private static final QName _cookies = new QName("", "cookies");
    private static final QName _domain = new QName("", "domain");
    private static final QName _name = new QName("", "name");
    private static final QName _value = new QName("", "value");
    private static final QName _path = new QName("", "path");
    private static final QName _expires = new QName("", "expires");
    private static final QName _version = new QName("", "version");
    private static final QName _secure = new QName("", "secure");
    private static final QName c_cookies = new QName("c", "http://www.w3.org/ns/xproc-step", "cookies");
    private static final QName c_cookie = new QName("c", "http://www.w3.org/ns/xproc-step", "cookie");
    private static DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private WritablePipe result = null;

    public GetCookies(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_cookies).getString();
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_cookies);
        treeWriter.startContent();
        for (Cookie cookie : this.runtime.getCookies(string)) {
            String string2;
            treeWriter.addStartElement(c_cookie);
            treeWriter.addAttribute(_name, cookie.getName());
            treeWriter.addAttribute(_value, cookie.getValue());
            treeWriter.addAttribute(_domain, cookie.getDomain());
            treeWriter.addAttribute(_path, cookie.getPath());
            Date date = cookie.getExpiryDate();
            if (date != null) {
                string2 = iso8601.format(date);
                string2 = string2.substring(0, 22) + ":" + string2.substring(22);
                treeWriter.addAttribute(_expires, string2);
                Date date2 = new Date();
            }
            treeWriter.startContent();
            string2 = cookie.getComment();
            if (string2 != null) {
                treeWriter.addText(string2);
            }
            treeWriter.addEndElement();
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

