"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = leastIndex;
var _ascending = _interopRequireDefault(require("./ascending.js"));
var _minIndex = _interopRequireDefault(require("./minIndex.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function leastIndex(values, compare = _ascending.default) {
  if (compare.length === 1) return (0, _minIndex.default)(values, compare);
  let minValue;
  let min = -1;
  let index = -1;
  for (const value of values) {
    ++index;
    if (min < 0 ? compare(value, value) === 0 : compare(value, minValue) < 0) {
      minValue = value;
      min = index;
    }
  }
  return min;
}