import React from "react";
type TAuthClientInitOptions = {
    [paramName: string]: unknown;
};
type TtokenParsed = {
    [paramName: string]: any;
};
export type TAuthClient = {
    login(): void;
    logout(): void;
    createAccountUrl(): string;
    init(initOptions: TAuthClientInitOptions): Promise<boolean>;
    updateToken(minValidity: number): Promise<boolean>;
    isTokenExpired(minValidity: number): boolean;
    token?: string;
    refreshToken?: string;
    tokenParsed?: TtokenParsed;
    authenticated?: boolean | undefined;
};
export type TKeycloakProviderProps = {
    authenticated: boolean | undefined;
    logout?(): void;
    login?(): void;
    updateToken?: Promise<boolean>;
    token?: string;
    refreshToken?: string;
    name?: string;
    email?: string;
    tokenParsed?: TtokenParsed;
    createAccountUrl?(): string;
};
export declare const useKeycloakContext: () => TKeycloakProviderProps;
export declare const KeycloakProvider: ({ children, authClient, }: {
    authClient: TAuthClient;
    children: React.ReactNode;
}) => import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=KeycloakProvider.d.ts.map