import { TActionMenuConfig, TTableConfig } from "../types";
import { ESortDirection, TPaging } from "../../../genericTypes";
import { TTopRowTableParams } from "../addons/TopRow";
import { TBottomRowTableParams } from "../addons/BottomRow";
export type THandleSortingChange = (args: {
    column: string;
    direction: ESortDirection;
}) => void;
export type THandlePagingChange = (args: Omit<TPaging, "totalDisplayableResults">) => void;
export type TTableClientSideProps<TDataType> = {
    data?: TDataType[];
    config: TTableConfig<TDataType>;
    onSelect?: (data: TDataType[]) => void;
    actionConfig?: TActionMenuConfig<TDataType>;
    isLoading?: boolean;
    onSortingChange?: THandleSortingChange;
    onPagingChange?: THandlePagingChange;
    defaultPaging?: Omit<TPaging, "totalDisplayableResults">;
    TopRow?: (props: TTopRowTableParams<TDataType>) => React.ReactNode;
    BottomRow?: (props: TBottomRowTableParams<TDataType>) => React.ReactNode;
};
export declare function TableClientSide<TDataType>({ data, config, onSelect, actionConfig, isLoading, onSortingChange, onPagingChange, defaultPaging, TopRow, BottomRow, }: TTableClientSideProps<TDataType>): import("react/jsx-runtime").JSX.Element;
//# sourceMappingURL=index.d.ts.map