import { RefObject } from "react";
import { TCascadeMenuForwardRef, TMeta } from "./index";
import { TCascadeOption, TCascadeOptionForwardRef } from "./CascadeOption";
export type TNode<Meta extends TMeta = object> = {
    _option: TCascadeOption<Meta>;
    elementRef: RefObject<HTMLDivElement>;
    cascadeOptionForwardRef: RefObject<TCascadeOptionForwardRef>;
    menuForwardRef: RefObject<TCascadeMenuForwardRef>;
    focused: boolean;
    hasChildren: boolean;
    children: TNode<Meta>[];
    parent: TNode<Meta> | null;
    index: number;
    previousNodeIndex: number;
    nextNodeIndex: number;
    id: string;
    level: number;
};
export declare const buildNodeTree: <Meta extends TMeta = object>(options: TCascadeOption<Meta>[]) => TNode<Meta>[];
export declare const nodeHelper: <Meta extends TMeta = object>(nodes: TNode<Meta>[]) => {
    getCurrentlyFocusedNode: () => TNode<Meta> | undefined;
    transformOneDimensionalNodesArrayIntoValues: (n?: TNode<Meta>[]) => TCascadeOption<Meta>[];
    getLevelOfCurrentlyFocusedNode: (n?: TNode<Meta>[]) => TNode<Meta>[] | undefined;
    getLevelOfNode: (n: TNode<Meta>[] | undefined, selector: (node: TNode<Meta>) => boolean) => TNode<Meta>[] | undefined;
    getNode: (n: TNode<Meta>[] | undefined, selector: (node: TNode<Meta>) => boolean) => TNode<Meta> | undefined;
    hasFocusedParent: (node: TNode<Meta>) => boolean;
    getTraceBackToFirstColumn: (node: TNode<Meta>) => TNode<Meta>[];
    forEachNode: (n: TNode<Meta>[] | undefined, action: (node: TNode<Meta>) => void) => void;
    focusTraceBackToFirstColumn: (node: TNode<Meta>) => void;
    filterOptionsByValue: (options: TCascadeOption<Meta>[], value: string) => TCascadeOption<Meta>[];
};
//# sourceMappingURL=utils.d.ts.map