'use client';
'use strict';

var dayjs = require('dayjs');
var shiftTimezone = require('./shift-timezone.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var dayjs__default = /*#__PURE__*/_interopDefault(dayjs);

function getDefaultClampedDate({ minDate, maxDate, timezone }) {
  const today = shiftTimezone.shiftTimezone("add", /* @__PURE__ */ new Date(), timezone);
  if (!minDate && !maxDate) {
    return today;
  }
  if (minDate && dayjs__default.default(today).isBefore(minDate)) {
    return minDate;
  }
  if (maxDate && dayjs__default.default(today).isAfter(maxDate)) {
    return maxDate;
  }
  return today;
}

exports.getDefaultClampedDate = getDefaultClampedDate;
//# sourceMappingURL=get-default-clamped-date.cjs.map
