"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"TableSessionStorage",{enumerable:true,get:function(){return TableSessionStorage}});const _helper=require("../../../helper");const _yup=require("yup");const _genericTypes=require("../../../genericTypes");function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const tableStoredSchema=(0,_yup.object)({sorting:(0,_yup.object)({direction:(0,_yup.string)().required().oneOf([_genericTypes.ESortDirection.ASC,_genericTypes.ESortDirection.DESC]),column:(0,_yup.string)().required()}).required(),paging:(0,_yup.object)({index:(0,_yup.number)().required(),size:(0,_yup.number)().required()}).required()});function validateTableData(data){let isValid=true;try{tableStoredSchema.validateSync(data,{strict:true,stripUnknown:true})}catch(_){isValid=false}return isValid}class TableSessionStorage{static Instance(){if(!this._instance)this._instance=new this;return this._instance}get(id){const storedTables=TableSessionStorage.storage.get(TableSessionStorage.sessionStorageKey)||{};const tableData=storedTables[id];if(!tableData)return null;const isValidData=validateTableData(tableData);if(!isValidData){const storedTableClone=structuredClone(storedTables);delete storedTableClone[id];TableSessionStorage.storage.set(TableSessionStorage.sessionStorageKey,storedTableClone);return null}return tableData}set(id,updateData){const storedTables=TableSessionStorage.storage.get(TableSessionStorage.sessionStorageKey)||{};const updatedData=updateData(storedTables[id]);const isValidData=validateTableData(updatedData);if(!isValidData){return}storedTables[id]=updatedData;TableSessionStorage.storage.set(TableSessionStorage.sessionStorageKey,storedTables);return}constructor(){}}_define_property(TableSessionStorage,"_instance",null);_define_property(TableSessionStorage,"sessionStorageKey",_helper.ESessionStorageKeys.TABLE);_define_property(TableSessionStorage,"storage",_helper.SessionStorage.Instance());
//# sourceMappingURL=TableSessionStorage.js.map