import { type UnbindFn } from 'bind-event-listener';
declare class ColorModeObserver {
    unbindThemeChangeListener: UnbindFn | null;
    getColorMode(): "light" | "dark";
    bind(): void;
    unbind(): void;
}
/**
 * A singleton color mode observer - binds "auto" switching logic to a single `mediaQueryList` listener
 * that can be unbound by any consumer when no longer needed.
 */
declare const SingletonColorModeObserver: ColorModeObserver;
export default SingletonColorModeObserver;
