/**
 * This is defined in the migration package instead of using `@atlaskit/pragmatic-drag-and-drop-live-region`
 * because RBD-style dragging has different needs to the alternative flows of PDND.
 *
 * RBD can make a lot of announcements in a short period, so delaying messages is not feasible.
 * RBD also maintains focus while dragging, so messages being skipped is less of a concern.
 *
 * `@atlaskit/pragmatic-drag-and-drop-live-region` has been tailored for PDND-specific alternative flows,
 * where focus usually changes around the time `announce()` is called. So in `@atlaskit/pragmatic-drag-and-drop-live-region`
 * messages have delays to avoid them being skipped.
 */
/**
 * Announces the provided message to assistive technology.
 */
export declare function announce(message: string): void;
/**
 * Removes the created live region. If there is no live region this is a no-op.
 */
export declare function cleanup(): void;
