import { useDragDropContext } from '../drag-drop-context/internal-context';
export function getDraggableDimensions(element) {
  var _window$getComputedSt = window.getComputedStyle(element),
    margin = _window$getComputedSt.margin;
  var rect = element.getBoundingClientRect();
  return {
    margin: margin,
    rect: rect
  };
}

/**
 * Returns the captured dimensions of the item being dragged.
 */
export function useDraggableDimensions() {
  var _useDragDropContext = useDragDropContext(),
    getDragState = _useDragDropContext.getDragState;
  var dragState = getDragState();
  if (!dragState.isDragging) {
    return null;
  }
  return dragState.draggableDimensions;
}