import { useEffect } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

export function getHiddenTextElementId(contextId) {
  return "rbd-lift-instruction-".concat(contextId);
}
export default function useHiddenTextElement(_ref) {
  var contextId = _ref.contextId,
    text = _ref.text;
  useEffect(function () {
    var id = getHiddenTextElementId(contextId);
    var el = document.createElement('div');

    // identifier
    el.id = id;

    // add the description text
    el.textContent = text;

    // Using `display: none` prevent screen readers from reading this element in the document flow
    // This element is used as a `aria-labelledby` reference for *other elements* and will be read out for those
    Object.assign(el.style, {
      display: 'none'
    });

    // Add to body
    document.body.appendChild(el);
    return function unmount() {
      // Remove from body
      el.remove();
    };
  }, [contextId, text]);
}