"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElementByDraggableLocation = getElementByDraggableLocation;
var _attributes = require("./attributes");
var _findElement = require("./find-element");
// eslint-disable-next-line import/no-extraneous-dependencies

function getElementByDraggableLocation(contextId, location) {
  if (!location) {
    return null;
  }
  return (0, _findElement.findElement)({
    attribute: _attributes.attributes.draggable.contextId,
    value: contextId
  }, {
    attribute: _attributes.customAttributes.draggable.droppableId,
    value: location.droppableId
  }, {
    attribute: _attributes.customAttributes.draggable.index,
    value: String(location.index)
  });
}