"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findClosestScrollContainer = findClosestScrollContainer;
/**
 * Ported from `react-beautiful-dnd`
 */
function findClosestScrollContainer(element) {
  var _getComputedStyle = getComputedStyle(element),
    overflowX = _getComputedStyle.overflowX,
    overflowY = _getComputedStyle.overflowY;
  if (overflowX === 'scroll' || overflowX === 'auto' || overflowY === 'scroll' || overflowY === 'auto') {
    return element;
  }
  var parentElement = element.parentElement;
  if (parentElement === null) {
    return null;
  }
  return findClosestScrollContainer(parentElement);
}