import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { EventEmitter2 } from 'eventemitter2';
export const ALL_FEATURE_VALUES = '@all-features';
export default class Subscriptions {
  constructor() {
    _defineProperty(this, "eventToValue", new Map());
    this.emitter = new EventEmitter2();
  }
  onGateUpdated(gateName, callback, checkGate, options) {
    const value = checkGate(gateName, {
      ...options,
      fireGateExposure: false
    });
    if (this.eventToValue.get(callback) === undefined) {
      this.eventToValue.set(callback, value);
    }
    const wrapCallback = () => {
      const value = checkGate(gateName, {
        ...options,
        fireGateExposure: false
      });
      const existingValue = this.eventToValue.get(callback);
      if (existingValue !== value) {
        this.eventToValue.set(callback, value);
        callback(value);
      }
    };
    this.emitter.on(gateName, wrapCallback);
    return () => {
      this.emitter.off(gateName, wrapCallback);
    };
  }
  onExperimentValueUpdated(experimentName, parameterName, defaultValue, callback, getExperimentValue, options) {
    const experimentEventName = `${experimentName}.${parameterName}`;
    const value = getExperimentValue(experimentName, parameterName, defaultValue, {
      ...options,
      fireExperimentExposure: false
    });
    if (this.eventToValue.get(callback) === undefined) {
      this.eventToValue.set(callback, value);
    }
    const wrapCallback = () => {
      const value = getExperimentValue(experimentName, parameterName, defaultValue, {
        ...options,
        fireExperimentExposure: false
      });
      const existingValue = this.eventToValue.get(callback);
      if (existingValue !== value) {
        this.eventToValue.set(callback, value);
        callback(value);
      }
    };
    this.emitter.on(experimentEventName, wrapCallback);
    return () => {
      this.emitter.off(experimentEventName, wrapCallback);
    };
  }
  onAnyUpdated(callback) {
    this.emitter.on(ALL_FEATURE_VALUES, callback);
    return () => {
      this.emitter.off(ALL_FEATURE_VALUES, callback);
    };
  }
  anyUpdated() {
    this.emitter.emit(ALL_FEATURE_VALUES);
    this.emitter.eventNames().filter(name => name !== ALL_FEATURE_VALUES).forEach(event => {
      this.emitter.emit(event);
    });
  }
}