"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useStateRef;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
/**
 * Functions similarly to `useState` however the return value is a ref.
 *
 * ```js
 * const [valueRef, setValue] = useStateRef(0);
 * ```
 *
 * @param initialState
 */
function useStateRef(initialState) {
  var _useState = (0, _react.useState)(initialState),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    value = _useState2[0],
    setValue = _useState2[1];
  var valueRef = (0, _react.useRef)(value);
  valueRef.current = value;
  return [valueRef, setValue];
}