"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useScrollbarWidth;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
/**
 * Get the scrollbar width of the container that the ref is assigned.
 *
 * ```js
 * const { width, ref } = useScrollbarWidth();
 * ```
 *
 * @returns Scrollbar width of the container and the element ref.
 */
function useScrollbarWidth() {
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    scrollbarWidth = _useState2[0],
    setScrollbarWidth = _useState2[1];
  var elementRef = (0, _react.useRef)(null);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  (0, _react.useEffect)(function () {
    if (!elementRef.current) {
      return;
    }
    var width = elementRef.current.offsetWidth - elementRef.current.scrollWidth;
    if (width === scrollbarWidth) {
      return;
    }
    setScrollbarWidth(width);
  });
  return {
    width: scrollbarWidth,
    ref: elementRef
  };
}