#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

outfile="${project}.sizeof_param"
bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/${outfile}.remove)
tmp=$(mktemp /tmp/smatch.XXXX)
tmp2=$(mktemp /tmp/smatch.XXXX)


echo "// list of function parameters that are the size of a buffer." > $outfile
echo '// generated by `gen_sizeof_param.sh`' >> $outfile

grep sizeof_param $file | grep '[0-9] [0-9]$' | cut -d ' ' -f 5- | \
    sort -u | sed -e "s/'//g" > $tmp
grep sizeof_param $file | grep '[0-9] -1$' | cut -d ' ' -f 5- | \
    sort -u | sed -e "s/'//g" >> $tmp
grep -f $remove $tmp >> $tmp2 2> /dev/null
cat $tmp $tmp2 2> /dev/null | sort | uniq -u >> $outfile
rm $tmp
rm $tmp2

echo "Done.  List saved as '$outfile'"

