/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.client;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthScheme;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthState;
import org.apache.maven.wagon.providers.http.httpclient.auth.Credentials;
import org.apache.maven.wagon.providers.http.httpclient.client.UserTokenHandler;
import org.apache.maven.wagon.providers.http.httpclient.conn.HttpRoutedConnection;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpRoutedConnection conn;
        Principal userPrincipal = null;
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = (HttpRoutedConnection)context.getAttribute("http.connection")).isOpen() && (sslsession = conn.getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

